/*
--             This file is part of the New World OS project
--                 Copyright (C) 2006-2009  QRW Software
--           J. Scott Edwards - j.scott.edwards.nwos@gmail.com 
--                      http://www.qrwsoftware.com
--                      http://nwos.sourceforge.com
--
--   This program is free software: you can redistribute it and/or modify
--   it under the terms of the GNU General Public License as published by
--   the Free Software Foundation, either version 3 of the License, or
--   (at your option) any later version.
--
--   This program is distributed in the hope that it will be useful,
--   but WITHOUT ANY WARRANTY; without even the implied warranty of
--   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
--   GNU General Public License for more details.
--
--   You should have received a copy of the GNU General Public License
--   along with this program, in the file LICENSE.  If not, see 
--   <http://www.gnu.org/licenses/>.
--
--   You can also contact me via paper mail at:
--
--      QRW Software
--      P.O. Box 27511
--      Salt Lake City, UT 84127-0511, USA.
--
--
-- $Log: strlcxx.c,v $
-- Revision 1.1  2009/03/13 03:06:16  jsedwards
-- Merged strlcat.c and strlcpy.c into strlcxx.c.
--
-- Revision 1.1  2009/03/08 19:15:47  jsedwards
-- Moved strlcpy function from log.c file.
--
-- Revision 1.1  2009/03/08 19:15:29  jsedwards
-- Moved strlcat function from log.c file.
--
*/

#ifndef HAVE_STRLCAT

#include <assert.h>
#include <stdlib.h>
#include <string.h>

#include "config.h"



/* From the OpenBSD man page:                                                        */
/*                                                                                   */
/* The strlcat() function appends the NUL-terminated string src to the end of dst.   */
/* It will append at most size - strlen(dst) - 1 bytes, NUL-terminating the result.  */

size_t strlcat(char* dst, const char* src, size_t size)
{
    int i, j;

    assert(size > 0);

    /* find the end of the destination string */
    /* if we don't find the null before size, don't write a zero */
    for (i = 0; dst[i] != '\0'; i++)
    {
	if (i >= size)
	{
	    return size + 1 + strlen(src);
	}
    }

    for (j = 0; src[j] != '\0'; j++)
    {
	if (i < size)
	{
	    dst[i] = src[j];
	}
	i++;
    }

    if (i < size)
    {
	dst[i] = src[j];
    }
    else
    {
	dst[size-1] = src[j];
    }

    return i;
}

#endif



#ifndef HAVE_STRLCPY

#include <assert.h>
#include <stdlib.h>

#include "config.h"


/* From the OpenBSD man page:                                       */
/*                                                                  */
/* The strlcpy() function copies up to size - 1 characters from the */
/* NUL-terminated string src to dst, NUL-terminating the result.    */

size_t strlcpy(char* dst, const char* src, size_t size)
{
    int i;

    assert(size > 0);

    for (i = 0; src[i] != '\0'; i++)
    {
	if (i < size)
	{
	    dst[i] = src[i];
	}
    }

    if (i < size)
    {
	dst[i] = src[i];
    }
    else
    {
	dst[size-1] = src[i];
    }

    return i;
}
#endif



