/*
--             This file is part of the New World OS project
--                 Copyright (C) 2005-2008  QRW Software
--           J. Scott Edwards - j.scott.edwards.nwos@gmail.com 
--                      http://www.qrwsoftware.com
--                      http://nwos.sourceforge.com
--
--   This program is free software: you can redistribute it and/or modify
--   it under the terms of the GNU General Public License as published by
--   the Free Software Foundation, either version 3 of the License, or
--   (at your option) any later version.
--
--   This program is distributed in the hope that it will be useful,
--   but WITHOUT ANY WARRANTY; without even the implied warranty of
--   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
--   GNU General Public License for more details.
--
--   You should have received a copy of the GNU General Public License
--   along with this program, in the file LICENSE.  If not, see 
--   <http://www.gnu.org/licenses/>.
--
--   You can also contact me via paper mail at:
--
--      QRW Software
--      P.O. Box 27511
--      Salt Lake City, UT 84127-0511, USA.
--
--
-- $Log: language.c,v $
-- Revision 1.15  2008/09/01 00:10:51  jsedwards
-- Fix copyright year.  NO code changes.
--
-- Revision 1.14  2008/08/31 17:58:26  jsedwards
-- Add assert around call to nwos_read_object_from_disk because it now returns
-- false when it fails, whereas before it would assert itself.
--
-- Revision 1.13  2007/07/01 19:44:12  jsedwards
-- Upgrade to GPLv3.
--
-- Revision 1.12  2007/01/06 20:10:41  jsedwards
-- Change to find_public_spelling instead of find_spelling.
--
-- Revision 1.11  2006/12/21 12:59:47  jsedwards
-- Hack to make it compile with new split public and private classes,
-- NON-FUNCTIONAL!
--
-- Revision 1.10  2006/12/07 14:08:46  jsedwards
-- Moved setup routine and associated functions to attic/big_bang.c.
--
-- Revision 1.9  2006/12/01 14:37:23  jsedwards
-- Fix the year in the copyright.
--
-- Revision 1.8  2006/12/01 14:31:30  jsedwards
-- Changed to use new malloc_reference_list and free_reference_list functions
-- instead of inlining the code.
--
-- Revision 1.7  2006/11/11 12:01:04  jsedwards
-- Update e-mail address to something that works.
--
-- Revision 1.6  2006/10/26 01:51:27  jsedwards
-- Merged alpha_05_branch back into main trunk.
--
-- Revision 1.5.2.1  2006/09/01 13:27:20  jsedwards
-- Changed "nwos_object_size" to "nwos_reference_list_size" and added the
-- object reference to "nwos_fill_in_common_header" so it can put the "id"
-- in the header now.
--
-- Revision 1.5  2005/12/29 17:50:53  jsedwards
-- Commented out printf debugging statements, that aren't useful now.
--
-- Revision 1.4  2005/12/29 17:01:41  jsedwards
-- Changed to just read spelling obj header to get reference list instead of
-- the whole variable sized object.
--
-- Revision 1.3  2005/12/27 18:34:05  jsedwards
-- Changed to look up class definition instead of using a fixed file name.
-- Also changed so that object id is random instead of fixed filename.
--
-- Revision 1.2  2005/12/24 16:18:26  jsedwards
-- Removed "host" id from object references (ObjRef).  Host redirection will
-- be done using a "redirection" object in the future.
--
-- Revision 1.1  2005/12/11 16:38:50  jsedwards
-- Moved create english language function from create_class_def file and
-- added "find_language" function.
--
*/


#include <assert.h>
#include <ctype.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>   /* define memset */

#include "crc32.h"
#include "objectify.h"
#include "objectify_private.h"


bool nwos_find_language(char* word, ObjRef* ref)
{
    C_struct_Word word_obj;
    EveryObject spelling_header;
    ObjRef word_class_ref;
    ObjRef lang_class_ref;
    ObjRef spelling_ref;
    ObjRef object_class;
    ReferenceList* ref_list;
    int num_spellings;
    int i;
    bool result = false;

    assert(nwos_find_public_class_definition("WORD", &word_class_ref));

    assert(nwos_find_public_class_definition("LANGUAGE", &lang_class_ref));

    if (nwos_find_public_spelling(word, &spelling_ref)) /* the spelling exists, search for word */
    {
	nwos_read_object_headers_from_disk(&spelling_ref, &spelling_header);

	ref_list = nwos_malloc_reference_list(&spelling_header.object.references);

	num_spellings = ref_list->common_header.num_refs;

	/* printf("num_spellings (in find_language): %d\n", num_spellings); */

	for (i = 0; i < num_spellings; i++)
	{
	    nwos_get_object_class(&ref_list->references[i], &object_class);   /* find out what kind of object it is */

	    if (is_same_object(&object_class, &word_class_ref))   /* it is a word object, figure out if it is a language */
	    {
		assert(nwos_read_object_from_disk(&ref_list->references[i], &word_obj, sizeof(word_obj)));

		nwos_get_object_class(&word_obj.thing, &object_class);   /* find out what kind of object it is */

		if (is_same_object(&object_class, &lang_class_ref))
		{
		    memcpy(ref, &word_obj.thing, sizeof(ObjRef));
		    result = true;
		    break;
		}
	    }
	}

	nwos_free_reference_list(ref_list);
	ref_list = NULL;
    }

    return result;
}


