/*
--             This file is part of the New World OS project
--                    Copyright (C) 2008 QRW Software
--           J. Scott Edwards - j.scott.edwards.nwos@gmail.com 
--                      http://www.qrwsoftware.com
--                      http://nwos.sourceforge.com
--
--   This program is free software: you can redistribute it and/or modify
--   it under the terms of the GNU General Public License as published by
--   the Free Software Foundation, either version 3 of the License, or
--   (at your option) any later version.
--
--   This program is distributed in the hope that it will be useful,
--   but WITHOUT ANY WARRANTY; without even the implied warranty of
--   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
--   GNU General Public License for more details.
--
--   You should have received a copy of the GNU General Public License
--   along with this program, in the file LICENSE.  If not, see 
--   <http://www.gnu.org/licenses/>.
--
--   You can also contact me via paper mail at:
--
--      QRW Software
--      P.O. Box 27511
--      Salt Lake City, UT 84127-0511, USA.
--
--
-- $Log: log_file.c,v $
-- Revision 1.4  2008/08/31 18:25:43  jsedwards
-- Change for new parameters to nwos_initialize_objectify without key stuff
-- and eliminate calle to nwos_set_root_object because initialize does that now.
--
-- Revision 1.3  2008/02/23 01:41:59  jsedwards
-- Changed to call new nwos_add_info_to_existing_file function to add SHA1 and
-- SHA256 sums to existing file.
--
-- Revision 1.2  2008/02/16 13:05:19  jsedwards
-- Changed AccessType to PUBLIC.
--
-- Revision 1.1  2007/11/24 17:06:12  jsedwards
-- Initial version.
--
*/

#include <stdio.h>

#include "../objectify_private.h"


int main(int argc, char* argv[])
{
    ObjRef ref;
    int i;
    ObjCreateResult result;

    nwos_log_arguments(argc, argv);

    nwos_initialize_objectify(PUBLIC, NULL);


    for (i = 1; i < argc; i++)
    {
	result = nwos_add_info_to_existing_file(argv[i], &ref);

	assert(!is_void_reference(&ref));

	if (result == FOUND_EXISTING)
	{
	    printf("updated file association: %02x%02x%02x%02x\n", 
		   ref.id[0], ref.id[1], ref.id[2], ref.id[3]);
	}
	else
	{
	    printf("result: %d\n", result);
	}

	nwos_flush_bit_maps();
    }


    nwos_terminate_objectify();

    return 0;
}


