# 
#              This file is part of the New World OS project
#                     Copyright (C) 2007 QRW Software
#            J. Scott Edwards - j.scott.edwards.nwos@gmail.com 
#                       http://www.qrwsoftware.com
#                       http://nwos.sourceforge.com
# 
#    This program is free software: you can redistribute it and/or modify
#    it under the terms of the GNU General Public License as published by
#    the Free Software Foundation, either version 3 of the License, or
#    (at your option) any later version.
# 
#    This program is distributed in the hope that it will be useful,
#    but WITHOUT ANY WARRANTY; without even the implied warranty of
#    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#    GNU General Public License for more details.
# 
#    You should have received a copy of the GNU General Public License
#    along with this program, in the file LICENSE.  If not, see 
#    <http://www.gnu.org/licenses/>.
# 
#    You can also contact me via paper mail at:
# 
#       QRW Software
#       P.O. Box 27511
#       Salt Lake City, UT 84127-0511, USA.
# 
# 
#  This script runs a quick test of file importing and exporting.
# 
#  $Log: test_import_export.sh,v $
#  Revision 1.3  2008/12/29 14:58:34  jsedwards
#  Changed so that it sets the environment variables itself, does the test in
#  the /tmp directory, tests exit codes and stops if it was incorrect, and
#  removed most of the sleep statements.
#
#  Revision 1.2  2008/07/12 03:14:26  jsedwards
#  Changed --remove option to verify_file to --remove-no-shred.
#
#  Revision 1.1  2008/06/05 14:44:49  jsedwards
#  Initial version.
#

export OBJECTIFY_TEST_ONLY_DO_NOT_USE="Import Export Test"
export OBJECTIFY_PRIVATE_PATH=/tmp/objectify_test/private.obj
export OBJECTIFY_LOG_FILE_PATH=/tmp/objectify_test/objectify_log
export OBJECTIFY_BACKUP_PATH=/tmp/objectify_test

EXEC=$PWD

if ! rm -fr /tmp/objectify_test; then
   echo ""
   echo "could not remove /tmp/objectify_test directory"
   echo ""
   exit 1
fi

if ! rm -fr /tmp/test; then
   echo ""
   echo "could not remove /tmp/objectify_test directory"
   echo ""
   exit 1
fi

mkdir /tmp/test
cp -p *.[ch] /tmp/test
cd /tmp/test

echo "---------------"
echo " prep disk..."
echo "---------------"
if ! $EXEC/prep_disk 128M; then
   echo ""
   echo "prep_disk failed"
   echo ""
   exit 1
fi

sleep 2

echo "---------------"
echo " import_files..."
echo "---------------"
if ! $EXEC/import_file *.[ch] > /tmp/test1.out; then
   echo ""
   echo "import_file failed"
   echo ""
   exit 1
fi


echo "-----------------"
echo " export_files..."
echo "-----------------"

mkdir test
cd test

if ! $EXEC/export_file "*"; then
   echo ""
   echo "export_file failed"
   echo ""
   exit 1
fi

for file in ../*.[ch]; do diff -s $file .; done
sleep 2

echo "-------------------"
echo " md5 checksums..."
echo "-------------------"

if ! $EXEC/list_files --md5  | tee ../a.md5; then
   echo ""
   echo "list_files --md5 failed"
   echo ""
   exit 1
fi

if ! md5sum -c ../a.md5; then
   echo ""
   echo "MD5 sum does not match"
   echo ""
   exit 1
fi


echo "-------------------"
echo " sha1 checksums..."
echo "-------------------"

if ! $EXEC/list_files --sha1  | tee ../a.sha1; then
   echo ""
   echo "list_files --sha1 failed"
   echo ""
   exit 1
fi

if ! sha1sum -c ../a.sha1; then
   echo ""
   echo "SHA1 sum does not match"
   echo ""
   exit 1
fi


echo "---------------------"
echo " sha256 checksums..."
echo "---------------------"

if ! $EXEC/list_files --sha256  | tee ../a.sha256; then
   echo ""
   echo "list_files --sha256 failed"
   echo ""
   exit 1
fi

if ! sha256sum -c ../a.sha256; then
   echo ""
   echo "MD5 sum does not match"
   echo ""
   exit 1
fi

echo "---------------------"
echo " sha512 checksums..."
echo "---------------------"

if ! $EXEC/list_files --sha512  | tee ../a.sha512; then
   echo ""
   echo "list_files --sha512 failed"
   echo ""
   exit 1
fi

if ! sha512sum -c ../a.sha512; then
   echo ""
   echo "SHA512 sum does not match"
   echo ""
   exit 1
fi


echo "---------------------"
echo " file revision..."
echo "---------------------"
sed -i -e "s/2005-2008/2005-2009/" computer.c

echo "---------------------"
echo " verify and remove..."
echo "---------------------"

if $EXEC/verify_file --remove-no-shred *; then
   echo ""
   echo "verify_file --remove-no-shred succeeded when one changed file was not removed"
   echo ""
   exit 1
fi

echo "---------------------"
echo " files left: "
ls

echo "---------------------"
echo " add-revision..."
echo "---------------------"
if ! $EXEC/import_file --add-revision computer.c; then
   echo ""
   echo "import_file --add-revision failed"
   echo ""
   exit 1
fi

cp -piv computer.c ../computer.c.save


echo "---------------------"
echo " verify and remove..."
echo "---------------------"
if ! $EXEC/verify_file --remove-no-shred *; then
   echo ""
   echo "verify_file --remove-no-shred succeeded"
   echo ""
   exit 1
fi

echo "---------------------"
echo " export files..."
echo "---------------------"
if ! $EXEC/export_file computer.c; then
   echo ""
   echo "export_file failed"
   echo ""
   exit 1
fi

rmdup ../computer.c.save computer.c


echo "---------------------"
echo " compress..."
echo "---------------------"
if ! $EXEC/compress_sparse ../compressed; then
   echo ""
   echo "compress_sparse failed"
   echo ""
   exit 1
fi


echo "--------------------------"
echo " prep disk for restore..."
echo "--------------------------"
if ! $EXEC/prep_disk --no-private 128M; then
   echo ""
   echo "prep_disk --no-private failed"
   echo ""
   exit 1
fi


echo "---------------------"
echo " expand..."
echo "---------------------"
if ! $EXEC/expand_sparse ../compressed; then
   echo ""
   echo "expand_sparse failed"
   echo ""
   exit 1
fi



if ! $EXEC/export_file "*"; then
   echo ""
   echo "export_file failed"
   echo ""
   exit 1
fi

for file in ../*.[ch]; do diff -s $file .; done


echo "-------------------"
echo " md5 checksums..."
echo "-------------------"

if ! $EXEC/list_files --md5  | tee ../a.md5; then
   echo ""
   echo "list_files --md5 failed"
   echo ""
   exit 1
fi

if ! md5sum -c ../a.md5; then
   echo ""
   echo "MD5 sum does not match"
   echo ""
   exit 1
fi


echo "-------------------"
echo " sha1 checksums..."
echo "-------------------"

if ! $EXEC/list_files --sha1  | tee ../a.sha1; then
   echo ""
   echo "list_files --sha1 failed"
   echo ""
   exit 1
fi

if ! sha1sum -c ../a.sha1; then
   echo ""
   echo "SHA1 sum does not match"
   echo ""
   exit 1
fi


echo "---------------------"
echo " sha256 checksums..."
echo "---------------------"

if ! $EXEC/list_files --sha256  | tee ../a.sha256; then
   echo ""
   echo "list_files --sha256 failed"
   echo ""
   exit 1
fi

if ! sha256sum -c ../a.sha256; then
   echo ""
   echo "MD5 sum does not match"
   echo ""
   exit 1
fi

echo "---------------------"
echo " sha512 checksums..."
echo "---------------------"

if ! $EXEC/list_files --sha512  | tee ../a.sha512; then
   echo ""
   echo "list_files --sha512 failed"
   echo ""
   exit 1
fi

if ! sha512sum -c ../a.sha512; then
   echo ""
   echo "SHA512 sum does not match"
   echo ""
   exit 1
fi


echo "---------------------"
echo " verify and remove..."
echo "---------------------"
if ! $EXEC/verify_file --remove-no-shred *; then
   echo ""
   echo "verify_file --remove-no-shred failed"
   echo ""
   exit 1
fi

echo "---------------------"
echo " files left: "
ls

echo "---------------------------"
echo " list revision and time..."
echo "---------------------------"
if ! $EXEC/list_files --time --revision; then
   echo ""
   echo "list_files --time --revision failed"
   echo ""
   exit 1
fi

echo ""
echo "All tests passed!"
echo ""

exit 0

