/*
--             This file is part of the New World OS project
--                 Copyright (C) 2004-2009  QRW Software
--           J. Scott Edwards - j.scott.edwards.nwos@gmail.com 
--                      http://www.qrwsoftware.com
--                      http://nwos.sourceforge.com
--
--   This program is free software: you can redistribute it and/or modify
--   it under the terms of the GNU General Public License as published by
--   the Free Software Foundation, either version 3 of the License, or
--   (at your option) any later version.
--
--   This program is distributed in the hope that it will be useful,
--   but WITHOUT ANY WARRANTY; without even the implied warranty of
--   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
--   GNU General Public License for more details.
--
--   You should have received a copy of the GNU General Public License
--   along with this program, in the file LICENSE.  If not, see 
--   <http://www.gnu.org/licenses/>.
--
--   You can also contact me via paper mail at:
--
--      QRW Software
--      P.O. Box 27511
--      Salt Lake City, UT 84127-0511, USA.
--
--
-- $Log: bit_map.h,v $
-- Revision 1.1  2009/03/14 03:23:34  jsedwards
-- Moved declarations for functions in bit_map.c from objectify.h and disk_io.h
-- files.
--
*/


#ifndef BIT_MAP_H
#define BIT_MAP_H

#include "reference.h"
#include "types.h"


extern void nwos_set_bit_in_map(uint32 block);
extern void nwos_clear_bit_in_map(uint32 block);
extern bool nwos_test_bit_in_map(uint32 block);

extern bool nwos_block_used(ObjRef* ref);

extern uint32 nwos_find_random_block_in_chunk(int info_index);
extern int    nwos_find_low_density_in_chunk(int info_index, int density);
extern uint32 nwos_find_next_empty_block(uint32 start_block, int density);

extern void nwos_flush_bit_maps();

extern void nwos_terminate_bit_map(void);

#endif

