/*
--         This file is part of the New World OS and Objectify projects
--                    Copyright (C) 2004-2009  QRW Software
--              J. Scott Edwards - j.scott.edwards.nwos@gmail.com 
--                         http://www.qrwsoftware.com
--                         http://nwos.sourceforge.com
--                      http://objectify.sourceforge.com
--
--   This program is free software: you can redistribute it and/or modify
--   it under the terms of the GNU General Public License as published by
--   the Free Software Foundation, either version 3 of the License, or
--   (at your option) any later version.
--
--   This program is distributed in the hope that it will be useful,
--   but WITHOUT ANY WARRANTY; without even the implied warranty of
--   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
--   GNU General Public License for more details.
--
--   You should have received a copy of the GNU General Public License
--   along with this program, in the file LICENSE.  If not, see 
--   <http://www.gnu.org/licenses/>.
--
--   You can also contact me via paper mail at:
--
--      QRW Software
--      P.O. Box 27511
--      Salt Lake City, UT 84127-0511, USA.
--
--
-- $Log: security.h,v $
-- Revision 1.1  2009/03/14 15:12:11  jsedwards
-- Created with declarations taken from the disk_io.h file.
--
*/


#ifndef SECURITY_H
#define SECURITY_H

#include "reference.h"
#include "types.h"


#define IVEC_SIZE 8  /* don't know for sure, the man page doesn't say, i made the buffer larger and looked at if afterwards. */


extern void nwos_get_key_from_password(uint8 key[], size_t key_size);
extern void nwos_setup_from_big_key(uint8 big_key[16 + 8 + 4], ObjRef* root_object_ref);

extern bool nwos_read_block_from_disk_and_decrypt(ObjRef* ref, void* object, size_t size, uint8 ivec[IVEC_SIZE], int seq);
extern bool nwos_read_block_from_disk_and_old_decrypt(ObjRef* ref, void* object, size_t size, uint8 ivec[IVEC_SIZE], int seq);
extern void nwos_write_block_to_disk_and_encrypt(ObjRef* ref, void* object, size_t size, uint8 ivec[IVEC_SIZE], int seq);


#endif

