--
--             This file is part of the New World OS project
--                    Copyright (C) 2008  QRW Software
--           J. Scott Edwards - j.scott.edwards.nwos@gmail.com 
--                      http://www.qrwsoftware.com
--                      http://nwos.sourceforge.com
--
--   This program is free software: you can redistribute it and/or modify
--   it under the terms of the GNU General Public License as published by
--   the Free Software Foundation, either version 3 of the License, or
--   (at your option) any later version.
--
--   This program is distributed in the hope that it will be useful,
--   but WITHOUT ANY WARRANTY; without even the implied warranty of
--   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
--   GNU General Public License for more details.
--
--   You should have received a copy of the GNU General Public License
--   along with this program, in the file LICENSE.  If not, see 
--   <http://www.gnu.org/licenses/>.
--
--   You can also contact me via paper mail at:
--
--      QRW Software
--      P.O. Box 27511
--      Salt Lake City, UT 84127-0511, USA.
--
--
-- $Log: class_definition.e,v $
-- Revision 1.1  2008/11/28 17:11:56  jsedwards
-- Initial experimental quick hack.
--
--


class CLASS_DEFINITION

inherit OBJECTIFY_OBJECT

creation find

feature

   name: STRING
--      do
--         Result := change this to read the name from the class definition object someday

   find(nm: STRING) is
      do
         !!name.copy(nm)
         !!reference.make

         if nwos_find_private_class_definition(name.to_external, reference.to_external) then
             std_output.put_string("class: ")
             std_output.put_string(name)
             std_output.put_string("  reference: ")
             reference.dump

             storage := wrapper_read_class_definition(reference.to_external)

--             std_output.put_string("Ref list count: ");
--             std_output.put_integer(references.count);
--             std_output.put_new_line;
         end

         
      end

feature {NONE}

   nwos_find_private_class_definition(class_name: POINTER; ref: POINTER): BOOLEAN is
      external "C"
      end

   wrapper_read_class_definition(ref: POINTER): POINTER is
      external "C"
      end

end

