/*
--             This file is part of the New World OS project
--                 Copyright (C) 2004-2009  QRW Software
--           J. Scott Edwards - j.scott.edwards.nwos@gmail.com 
--                      http://www.qrwsoftware.com
--                      http://nwos.sourceforge.com
--
--   This program is free software: you can redistribute it and/or modify
--   it under the terms of the GNU General Public License as published by
--   the Free Software Foundation, either version 3 of the License, or
--   (at your option) any later version.
--
--   This program is distributed in the hope that it will be useful,
--   but WITHOUT ANY WARRANTY; without even the implied warranty of
--   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
--   GNU General Public License for more details.
--
--   You should have received a copy of the GNU General Public License
--   along with this program, in the file LICENSE.  If not, see 
--   <http://www.gnu.org/licenses/>.
--
--   You can also contact me via paper mail at:
--
--      QRW Software
--      P.O. Box 27511
--      Salt Lake City, UT 84127-0511, USA.
--
--
-- $Log: log.h,v $
-- Revision 1.1  2009/03/13 04:48:47  jsedwards
-- Moved various declarations from objectify.h.
--
*/


#ifndef LOG_H
#define LOG_H

#include "types.h"


extern void nwos_log(char* str);
extern void nwos_log_arguments(int argc, char* argv[]);
extern void nwos_log_md5sum(const char* file_name, uint8 md5_digest[MD5_DIGEST_SIZE]);
extern void nwos_log_sha1sum(const char* file_name, uint8 sha1_digest[SHA1_DIGEST_SIZE]);
extern void nwos_log_sha256sum(const char* file_name, uint8 sha256_digest[SHA256_DIGEST_SIZE]);
extern void nwos_log_sha512sum(const char* file_name, uint8 sha512_digest[SHA512_DIGEST_SIZE]);

#endif

