# 
#              This file is part of the New World OS project
#                     Copyright (C) 2007 QRW Software
#            J. Scott Edwards - j.scott.edwards.nwos@gmail.com 
#                       http://www.qrwsoftware.com
#                       http://nwos.sourceforge.com
# 
#    This program is free software: you can redistribute it and/or modify
#    it under the terms of the GNU General Public License as published by
#    the Free Software Foundation, either version 3 of the License, or
#    (at your option) any later version.
# 
#    This program is distributed in the hope that it will be useful,
#    but WITHOUT ANY WARRANTY; without even the implied warranty of
#    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#    GNU General Public License for more details.
# 
#    You should have received a copy of the GNU General Public License
#    along with this program, in the file LICENSE.  If not, see 
#    <http://www.gnu.org/licenses/>.
# 
#    You can also contact me via paper mail at:
# 
#       QRW Software
#       P.O. Box 27511
#       Salt Lake City, UT 84127-0511, USA.
# 
# 
#  This script runs a quick test of file importing and exporting.
# 
#  $Log: test_diff_compressed.sh,v $
#  Revision 1.2  2009/07/18 04:14:03  jsedwards
#  Fix wrong name in print (echo) statement.
#
#  Revision 1.1  2009/07/10 11:24:09  jsedwards
#  Initial version created from test_import_sizes.sh.
#
#

export OBJECTIFY_TEST_ONLY_DO_NOT_USE="Diff Compressed Test"
export OBJECTIFY_PRIVATE_PATH=/tmp/objectify_test/private.obj
export OBJECTIFY_LOG_FILE_PATH=/tmp/objectify_test/objectify_log
export OBJECTIFY_BACKUP_PATH=/tmp/objectify_test

EXEC=$PWD

if ! rm -fr /tmp/objectify_test; then
   echo ""
   echo "could not remove /tmp/objectify_test directory"
   echo ""
   exit 1
fi

if ! rm -fr /tmp/test; then
   echo ""
   echo "could not remove /tmp/objectify_test directory"
   echo ""
   exit 1
fi


mkdir /tmp/test
cd /tmp/test

echo "----------------------"
echo " creating test files"
echo "----------------------"

#dd if=/dev/random of=x7 bs=7 count=1

echo "WARNING: NOT using random data!!!!!"
echo -n "1234567" > x7

cat          x7          x7 >        x14
cat         x14         x14 >        x28
cat         x28         x28 >        x56
cat         x56         x56 >       x112
cat        x112        x112 >       x224
cat        x224        x224 >       x448
cat        x448        x448 >       x896
cat        x896        x896 >      x1792
cat       x1792       x1792 >      x3584
cat       x3584       x3584 >      x7168
cat       x7168       x7168 >     x14336
cat      x14336      x14336 >     x28672
cat      x28672      x28672 >     x57344
cat      x57344      x57344 >    x114688
cat     x114688     x114688 >    x229376
cat     x229376     x229376 >    x458752
cat     x458752     x458752 >    x917504
cat     x917504     x917504 >   x1835008
cat    x1835008    x1835008 >   x3670016
cat    x3670016    x3670016 >   x7340032
cat    x7340032    x7340032 >  x14680064
cat   x14680064   x14680064 >  x29360128


echo "---------------"
echo " prep disk..."
echo "---------------"
if ! $EXEC/prep_disk; then
   echo ""
   echo "prep_disk failed"
   echo ""
   exit 1
fi

mkdir /tmp/objectify_test/save
mv -i /tmp/objectify_test/*.dif  /tmp/objectify_test/save

sleep 2

echo "---------------------"
echo " compress before..."
echo "---------------------"
if ! $EXEC/compress_sparse /tmp/objectify_test/compressed-before; then
   echo ""
   echo "compress_sparse failed"
   echo ""
   exit 1
fi

sleep 2

echo "---------------"
echo " import_files..."
echo "---------------"
if ! $EXEC/import_file x1*; then
   echo ""
   echo "import_file failed"
   echo ""
   exit 1
fi

sleep 1

if ! $EXEC/import_file x2*; then
   echo ""
   echo "import_file failed"
   echo ""
   exit 1
fi

sleep 1

if ! $EXEC/import_file x3*; then
   echo ""
   echo "import_file failed"
   echo ""
   exit 1
fi

sleep 1

if ! $EXEC/import_file x4*; then
   echo ""
   echo "import_file failed"
   echo ""
   exit 1
fi

sleep 1

if ! $EXEC/import_file x5*; then
   echo ""
   echo "import_file failed"
   echo ""
   exit 1
fi

sleep 1

if ! $EXEC/import_file x7*; then
   echo ""
   echo "import_file failed"
   echo ""
   exit 1
fi

sleep 1

if ! $EXEC/import_file x8*; then
   echo ""
   echo "import_file failed"
   echo ""
   exit 1
fi

sleep 1

if ! $EXEC/import_file x9*; then
   echo ""
   echo "import_file failed"
   echo ""
   exit 1
fi

sleep 2


echo "---------------------"
echo " compress after..."
echo "---------------------"
if ! $EXEC/compress_sparse /tmp/objectify_test/compressed-after; then
   echo ""
   echo "compress_sparse failed"
   echo ""
   exit 1
fi

sleep 2


echo "---------------------"
echo " diff compressed..."
echo "---------------------"
if ! $EXEC/diff_compressed /tmp/objectify_test/compressed-before /tmp/objectify_test/compressed-after /tmp/objectify_test/diff-before-after > /tmp/objectify_test/diff-before-after.txt; then
   echo ""
   echo "diff_compressed failed"
   echo ""
   exit 1
fi

sleep 2


echo "---------------------"
echo " combine backups..."
echo "---------------------"
if ! $EXEC/combine_backup_files /tmp/objectify_test/*.dif /tmp/objectify_test/combined-before-after; then
   echo ""
   echo "combine_backup_files failed"
   echo ""
   exit 1
fi

sleep 2


echo "-------------------------------------------"
echo " verify diff and combined are the same..."
echo "-------------------------------------------"
if ! diff -s /tmp/objectify_test/diff-before-after /tmp/objectify_test/combined-before-after; then
   echo ""
   echo "combined and diff files differ"
   echo ""
   exit 1
fi

sleep 2


echo "---------------------"
echo " patch compressed..."
echo "---------------------"
if ! $EXEC/patch_compressed /tmp/objectify_test/compressed-before /tmp/objectify_test/combined-before-after /tmp/objectify_test/patched-after > /tmp/objectify_test/patched-after.txt; then
   echo ""
   echo "patch_compressed failed"
   echo ""
   exit 1
fi

sleep 2



echo "-------------------------------------------"
echo " verify diff and combined are the same..."
echo "-------------------------------------------"
if ! diff -s /tmp/objectify_test/compressed-after /tmp/objectify_test/patched-after; then
   echo ""
   echo "compressed and patched files differ"
   echo ""
   exit 1
fi

sleep 2



echo "--------------------------"
echo " prep disk for restore..."
echo "--------------------------"
if ! $EXEC/prep_disk --no-private; then
   echo ""
   echo "prep_disk --no-private failed"
   echo ""
   exit 1
fi


echo "---------------------"
echo " expand..."
echo "---------------------"
if ! $EXEC/expand_sparse /tmp/objectify_test/patched-after; then
   echo ""
   echo "expand_sparse failed"
   echo ""
   exit 1
fi



if ! $EXEC/export_file "*"; then
   echo ""
   echo "export_file failed"
   echo ""
   exit 1
fi

for file in ../*.[ch]; do diff -s $file .; done


echo "---------------------"
echo " verify and remove..."
echo "---------------------"
if ! $EXEC/verify_file --remove-no-shred *; then
   echo ""
   echo "verify_file --remove-no-shred failed"
   echo ""
   exit 1
fi

echo ""
echo "All tests passed!"
echo ""

exit 0

