/*
--             This file is part of the New World OS project
--                 Copyright (C) 2007-2009  QRW Software
--           J. Scott Edwards - j.scott.edwards.nwos@gmail.com 
--                      http://www.qrwsoftware.com
--                      http://nwos.sourceforge.com
--
--   This program is free software: you can redistribute it and/or modify
--   it under the terms of the GNU General Public License as published by
--   the Free Software Foundation, either version 3 of the License, or
--   (at your option) any later version.
--
--   This program is distributed in the hope that it will be useful,
--   but WITHOUT ANY WARRANTY; without even the implied warranty of
--   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
--   GNU General Public License for more details.
--
--   You should have received a copy of the GNU General Public License
--   along with this program, in the file LICENSE.  If not, see 
--   <http://www.gnu.org/licenses/>.
--
--   You can also contact me via paper mail at:
--
--      QRW Software
--      P.O. Box 27511
--      Salt Lake City, UT 84127-0511, USA.
--
--
-- $Log: list_public_spellings.c,v $
-- Revision 1.10  2009/06/13 11:47:36  jsedwards
-- Merged changes from Alpha_29.10 branch (version Alpha_29.11).
--
-- Revision 1.9.2.1  2009/05/23 03:51:26  jsedwards
-- Added include of disk_io.h to define file block size.
--
-- Revision 1.9  2009/03/08 19:38:10  jsedwards
-- Fixed year in Copyright.
--
-- Revision 1.8  2009/03/08 17:05:56  jsedwards
-- Changed include objectify_private.h to objectify.h.
--
-- Revision 1.7  2008/09/01 00:23:06  jsedwards
-- Fix year in copyright.  NO code changes.
--
-- Revision 1.6  2008/08/31 18:25:42  jsedwards
-- Change for new parameters to nwos_initialize_objectify without key stuff
-- and eliminate calle to nwos_set_root_object because initialize does that now.
--
-- Revision 1.5  2008/08/31 17:03:12  jsedwards
-- Added assert around calls to nwos_read_variable_sized_object_from_disk
-- because it now returns false if it fails instead of asserting itself.
--
-- Revision 1.4  2008/03/28 11:46:33  jsedwards
-- Change to pass 'PUBLIC' type to nwos_initialize_objectify.
--
-- Revision 1.3  2007/08/21 18:30:31  jsedwards
-- Removed call to set security (was called encryption) level, not required
-- when read-only.
--
-- Revision 1.2  2007/07/06 12:33:17  jsedwards
-- Change to not pass in default file info (because this is compiled public).
--
-- Revision 1.1  2007/07/05 19:17:48  jsedwards
-- Initial version.
--
*/


#include <assert.h>
#include <ctype.h>
#include <fcntl.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <unistd.h>

#include "../crc32.h"
#include "../disk_io.h"
#include "../objectify.h"


static size_t get_spelling_object_size(void* spelling_obj)
{
    assert(((C_struct_Spelling*)spelling_obj)->count > 0);
    return sizeof(C_struct_Spelling) + ((C_struct_Spelling*)spelling_obj)->count;
}

#if 0
static size_t get_name_object_size(void* name_obj)
{
    assert(((C_struct_Name*)name_obj)->count > 0);
    return sizeof(C_struct_Name) + (((C_struct_Name*)name_obj)->count * sizeof(ObjRef));
}
#endif

static size_t get_class_object_size(void* class_obj)
{
    return sizeof(C_struct_Class_Definition) + (((C_struct_Class_Definition*)class_obj)->count * sizeof(ObjRef));
}



int main(int argc, char* argv[])
{
    ObjRef spelling_class_ref;
    uint8 kludge[FILE_BLOCK_SIZE];
    C_struct_Class_Definition* spelling_class_ptr = (C_struct_Class_Definition*)kludge;
    C_struct_Spelling* spelling_ptr = (C_struct_Spelling*)kludge;
    ReferenceList* ref_list;
    int num_refs;
    int i;
    char spelling[64];

    nwos_log_arguments(argc, argv);

    nwos_initialize_objectify(PUBLIC, NULL);


    assert(nwos_find_public_class_definition("SPELLING", &spelling_class_ref));

    printf("Spelling class reference: %02x%02x%02x%02x\n",
	   spelling_class_ref.id[0],
	   spelling_class_ref.id[1],
	   spelling_class_ref.id[2],
	   spelling_class_ref.id[3]);


    assert(nwos_read_variable_sized_object_from_disk(&spelling_class_ref, kludge, sizeof(kludge), &get_class_object_size));

    ref_list = nwos_malloc_reference_list(&spelling_class_ptr->header.object.references);
    num_refs = ref_list->common_header.num_refs;

    printf("Number of spellings: %d\n", num_refs);

    for (i = 0; i < num_refs; i++)
    {
	assert(nwos_read_variable_sized_object_from_disk(&ref_list->references[i], kludge, sizeof(kludge), &get_spelling_object_size));

	memcpy(spelling, spelling_ptr->storage, spelling_ptr->count);
	spelling[spelling_ptr->count] = '\0';

	printf("%s\n", spelling);
    }

    nwos_free_reference_list(ref_list);
    ref_list = NULL;

    nwos_terminate_objectify();

    return 0;
}

