/*
--          This file is part of the New World OS and Objectify projects
--               Copyright (C) 2005, 2006, 2007, 2009  QRW Software
--               J. Scott Edwards - j.scott.edwards.nwos@gmail.com 
--
--   This program is free software: you can redistribute it and/or modify
--   it under the terms of the GNU General Public License as published by
--   the Free Software Foundation, either version 3 of the License, or
--   (at your option) any later version.
--
--   This program is distributed in the hope that it will be useful,
--   but WITHOUT ANY WARRANTY; without even the implied warranty of
--   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
--   GNU General Public License for more details.
--
--   You should have received a copy of the GNU General Public License
--   along with this program, in the file LICENSE.  If not, see 
--   <http://www.gnu.org/licenses/>.
--
--   For the latest information, source code (SVN), releases, bug and feature
--   request tracking go to:
--      http://sourceforge.net/projects/objectify
--
--   For older bug tracking, releases and source code (CVS) prior to the
--   Alpha_30 release go to:
--      http://sourceforge.net/projects/nwos
--
--   Other related websites:
--      http://www.qrwsoftware.com
--      http://www.worldwide-database.org
--
--   You can also contact me via paper mail at:
--
--      QRW Software
--      P.O. Box 27511
--      Salt Lake City, UT 84127-0511, USA.
--
--   $Author: jsedwards $
--   $Date: 2009-07-25 17:25:15 -0600 (Sat, 25 Jul 2009) $
--   $Revision: 4184 $
--
--   NOTE: Subversion does not support the Log keyword so I have removed the
--   logs that were here when I was using CVS.  Use the "svn log" command to
--   see the revision history of this file.
--   (See http://subversion.tigris.org/faq.html#log-in-source)
--
*/


#include <assert.h>
#include <ctype.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>   /* define memset */

#include "crc32.h"
#include "objectify.h"


bool nwos_find_state_postal_code(char* state_postal_code, ObjRef* ref)
{
    EveryObject spelling_header;
    ObjRef state_class_ref;
    ObjRef spelling_ref;
    ObjRef object_class;
    ReferenceList* ref_list;
    int num_spellings;
    int i;
    bool result = false;

    assert(strlen(state_postal_code) == 2);

    assert(nwos_find_public_class_definition("US STATE", &state_class_ref));

    if (nwos_find_public_spelling(state_postal_code, &spelling_ref))
    {
	nwos_read_object_headers_from_disk(&spelling_ref, &spelling_header);

	ref_list = nwos_malloc_reference_list(&spelling_header.object.references);

	num_spellings = ref_list->common_header.num_refs;

	/* printf("num_spellings (in find_state_postal_code): %d\n", num_spellings); */

	for (i = 0; i < num_spellings; i++)
	{
	    nwos_get_object_class(&ref_list->references[i], &object_class);   /* find out what kind of object it is */

	    if (is_same_object(&object_class, &state_class_ref))   /* it is a state_postal_code object */
	    {
		memcpy(ref, &ref_list->references[i], sizeof(ObjRef));
		result = true;
		break;
	    }
	}

	nwos_free_reference_list(ref_list);
	ref_list = NULL;
    }

    return result;
}

#if 0

nwos_add_address(&address_ref)
{
    ObjRef reference;
    char street[80];
    ObjRef address_class_ref;
    ObjRef city_ref;
    char* error_msg;


    nwos_find_private_class_definition("ADDRESS", &addres_class_ref);

    ok = false;
    while (!ok)
    {
	nwos_ask_user("street", street, sizeof(street));
	ok = nwos_is_valid_street_address(street, error_msg);
	if (!ok) 
	{
	    printf("%s\n", error_msg);
	    printf("Please re-enter.\n");
	}
    }

    nwos_add_city(&city_ref);

    memset(&address_obj, 0, sizeof(address_obj));

	nwos_generate_new_id(&reference);

	nwos_fill_in_common_header(&address_obj.header.common, &reference, &address_class_ref);

	nwos_create_name(first_name, &address_obj.first_name);
	nwos_add_to_references(&reference, &address_obj.first_name);

	nwos_create_reference_list(&reference, &address_obj.header.object.references);

	nwos_crc32_calculate((uint8*) &address_obj.header.object, sizeof(ObjectHeader), address_obj.header.common.header_chksum);

	nwos_crc32_calculate((uint8*) &address_obj.gender, sizeof(address_obj) - sizeof(EveryObject), address_obj.header.common.data_chksum);

	nwos_write_object_to_disk(&reference, &address_obj, sizeof(address_obj));

        nwos_add_to_references(&reference, &address_class_ref);
	
	printf("Address created: %08lx\n", nwos_ref_to_word(&reference));
    }
}

#endif

