--
--          This file is part of the New World OS and Objectify projects
--                  Copyright (C) 2006, 2007, 2009  QRW Software
--               J. Scott Edwards - j.scott.edwards.nwos@gmail.com 
--
--   This program is free software: you can redistribute it and/or modify
--   it under the terms of the GNU General Public License as published by
--   the Free Software Foundation, either version 3 of the License, or
--   (at your option) any later version.
--
--   This program is distributed in the hope that it will be useful,
--   but WITHOUT ANY WARRANTY; without even the implied warranty of
--   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
--   GNU General Public License for more details.
--
--   You should have received a copy of the GNU General Public License
--   along with this program, in the file LICENSE.  If not, see 
--   <http://www.gnu.org/licenses/>.
--
--   For the latest information, source code (SVN), releases, bug and feature
--   request tracking go to:
--      http://sourceforge.net/projects/objectify
--
--   For older bug tracking, releases and source code (CVS) prior to the
--   Alpha_30 release go to:
--      http://sourceforge.net/projects/nwos
--
--   Other related websites:
--      http://www.qrwsoftware.com
--      http://www.worldwide-database.org
--
--   You can also contact me via paper mail at:
--
--      QRW Software
--      P.O. Box 27511
--      Salt Lake City, UT 84127-0511, USA.
--
--   $Author: jsedwards $
--   $Date: 2009-07-25 17:25:15 -0600 (Sat, 25 Jul 2009) $
--   $Revision: 4184 $
--
--   NOTE: Subversion does not support the Log keyword so I have removed the
--   logs that were here when I was using CVS.  Use the "svn log" command to
--   see the revision history of this file.
--   (See http://subversion.tigris.org/faq.html#log-in-source)
--


class NAME

inherit GLOBALS
        REFERENCE_COUNTER
        ANY
           redefine
              is_equal
           end

creation make, make_from_csv

feature

   reference: UNSIGNED

   reference_list: REFERENCE_LIST

   spellings: FIXED_ARRAY[SPELLING]

   name: STRING is
      local
         i: INTEGER
         size: INTEGER
      do
         if name_string = Void then
            from
               i := spellings.lower
            variant
               spellings.upper - i
            until
               i > spellings.upper
            loop
               size := size + spellings.item(i).spelling.count + 1
               i := i + 1
            end

            !!name_string.make(size)
         else
            name_string.clear
         end

         from
            i := spellings.lower
         variant
            spellings.upper - i
         until
            i > spellings.upper
         loop
            if i > spellings.lower then
               name_string.extend('_')
            end
            name_string.append(spellings.item(i).spelling)
            i := i + 1
         end

         Result := name_string
      end

   name_capitalized: STRING is
      local
         i: INTEGER
      do
         Result := name

         Result.put(Result.first.to_upper, 1)

         if Result.has_prefix("Us_") then
            Result.put(Result.item(2).to_upper, 2)
         end

         if Result.has_prefix("Cd_") then
            Result.put(Result.item(2).to_upper, 2)
         end

         if Result.has_prefix("Md5") then
            Result.put(Result.item(2).to_upper, 2)
         end

         if Result.has_prefix("Sha1") then
            Result.put(Result.item(2).to_upper, 2)
            Result.put(Result.item(3).to_upper, 3)
         end

         from
            i := 2
         until
            i > Result.upper
         loop
            if Result.item(i) = '_' then
               i := i + 1
               Result.put(Result.item(i).to_upper, i)
            end
            i := i + 1
         end
      end

   is_equal(other: like Current): BOOLEAN is
      local
         i: INTEGER
      do
         if spellings.count = other.spellings.count then
            from
               i := spellings.lower
            variant
               spellings.upper - i
            until
               i > spellings.upper or else spellings.item(i) /= other.spellings.item(i)
            loop
               i := i + 1
            end

            Result := i > spellings.upper
         end
      end

   make(nm: STRING) is
      require
         nm.count > 0
         find_name(nm) = Void
      local
         tmp_str: STRING
         start: INTEGER
         i: INTEGER
         spell: SPELLING
      do
         reference := next_reference

         !!reference_list.make

         !!spellings.with_capacity(4)

         tmp_str := string_pool.item(nm.count)

         from
            i := nm.lower
            start := i
         variant
            nm.upper - i
         until
            i > nm.upper
         loop
            if nm.item(i) = '_' then
               tmp_str.copy_substring(nm, start, i - 1)
               start := i + 1
            elseif i = nm.upper then
               tmp_str.copy_substring(nm, start, i)
            end

            if tmp_str.count > 0 then
               spell := find_spelling(tmp_str)

               if spell = Void then
                  !!spell.make(tmp_str)
               end

               spell.reference_list.add_reference(reference)

               spellings.add_last(spell)

               tmp_str.clear
            end

            i := i + 1
         end

         all_names.add_last(Current)

         name_class_def.reference_list.add_reference(reference)

         string_pool.put(tmp_str)
      ensure
         name.same_as(nm)
      end


   make_from_csv(line: STRING) is
      local
         dummy: UNSIGNED
      do
         !!spellings.with_capacity(4)

         reference := scan_reference(line)

         check_comma(line)

         skip_time(line)

         check_comma(line)

         dummy := scan_reference(line)   -- ignore class for now

         check_comma(line)

         dummy := scan_reference(line)   -- ignore refernce list for now

         from
         until
            line.is_empty
         loop
            check_comma(line)

            dummy := scan_reference(line)  -- read first spelling

            spellings.add_last(find_spelling_from_reference(dummy))
         end
      end



feature {NONE}

   name_string: STRING

end

