/*
--          This file is part of the New World OS and Objectify projects
--                     Copyright (C) 2008, 2009  QRW Software
--               J. Scott Edwards - j.scott.edwards.nwos@gmail.com 
--
--   This program is free software: you can redistribute it and/or modify
--   it under the terms of the GNU General Public License as published by
--   the Free Software Foundation, either version 3 of the License, or
--   (at your option) any later version.
--
--   This program is distributed in the hope that it will be useful,
--   but WITHOUT ANY WARRANTY; without even the implied warranty of
--   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
--   GNU General Public License for more details.
--
--   You should have received a copy of the GNU General Public License
--   along with this program, in the file LICENSE.  If not, see 
--   <http://www.gnu.org/licenses/>.
--
--   For the latest information, source code (SVN), releases, bug and feature
--   request tracking go to:
--      http://sourceforge.net/projects/objectify
--
--   For older bug tracking, releases and source code (CVS) prior to the
--   Alpha_30 release go to:
--      http://sourceforge.net/projects/nwos
--
--   Other related websites:
--      http://www.qrwsoftware.com
--      http://www.worldwide-database.org
--
--   You can also contact me via paper mail at:
--
--      QRW Software
--      P.O. Box 27511
--      Salt Lake City, UT 84127-0511, USA.
--
--   $Author: jsedwards $
--   $Date: 2009-07-25 17:25:15 -0600 (Sat, 25 Jul 2009) $
--   $Revision: 4184 $
--
--   NOTE: Subversion does not support the Log keyword so I have removed the
--   logs that were here when I was using CVS.  Use the "svn log" command to
--   see the revision history of this file, the prep_disk.c file, and the
--   disk_io.c file where these functions originated.
--   (See http://subversion.tigris.org/faq.html#log-in-source)
--
*/

#include <assert.h>
#include <stdio.h>

#include "progress_bar.h"
#include "types.h"            /* define uint */


/***************************************/
/*  Functions to print a progress bar  */
/***************************************/

static uint progress_bar_percent;
static int num_chars;

static void put_char(char c)
{
    fputc(c, stdout);
    fflush(stdout);
    num_chars++;
}


static void put_string(char* s)
{
    while (*s != '\0')
    {
	put_char(*s);
	s++;
    }
}


static void put_decade(uint d)
{
    if (d == 0)
    {
	put_string("0");
    }
    else if (d > 99)
    {
	put_string("100");
    }
    else
    {
	put_char('0' + d / 10);
	put_char('0');
    }
}


void nwos_start_progress_bar()
{
    progress_bar_percent = 0;

    put_string("Percent complete: ");
}


void nwos_update_progress_bar(float percent)  /* 0.0 <= percent < 1.0 */
{
    assert(percent <= 1.0f);
    assert(progress_bar_percent <= 102);

    while (percent >= (float)progress_bar_percent / 100)
    {
	if (progress_bar_percent % 10 == 0)
	{
	    put_decade(progress_bar_percent);
	}
	else
	{
	    put_char('.');
	}
	fflush(stdout);

	progress_bar_percent += 2;
    }
}


void nwos_erase_progress_bar()
{
    int i;

    for (i = 0; i < num_chars; i++) fputc('\b', stdout);
    fflush(stdout);

    num_chars = 0;
    progress_bar_percent = 0;
}


void nwos_finish_progress_bar()
{
    assert(progress_bar_percent <= 102);

    while (progress_bar_percent <= 100)
    {
	if (progress_bar_percent % 10 == 0)
	{
	    put_decade(progress_bar_percent);
	}
	else
	{
	    put_char('.');
	}

	progress_bar_percent += 2;
    }

    fputc('\n', stdout);

    num_chars = 0;
}


