/*
--          This file is part of the New World OS and Objectify projects
--                  Copyright (C) 2007, 2008, 2009  QRW Software
--               J. Scott Edwards - j.scott.edwards.nwos@gmail.com 
--
--   This program is free software: you can redistribute it and/or modify
--   it under the terms of the GNU General Public License as published by
--   the Free Software Foundation, either version 3 of the License, or
--   (at your option) any later version.
--
--   This program is distributed in the hope that it will be useful,
--   but WITHOUT ANY WARRANTY; without even the implied warranty of
--   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
--   GNU General Public License for more details.
--
--   You should have received a copy of the GNU General Public License
--   along with this program, in the file LICENSE.  If not, see 
--   <http://www.gnu.org/licenses/>.
--
--   For the latest information, source code (SVN), releases, bug and feature
--   request tracking go to:
--      http://sourceforge.net/projects/objectify
--
--   For older bug tracking, releases and source code (CVS) prior to the
--   Alpha_30 release go to:
--      http://sourceforge.net/projects/nwos
--
--   Other related websites:
--      http://www.qrwsoftware.com
--      http://www.worldwide-database.org
--
--   You can also contact me via paper mail at:
--
--      QRW Software
--      P.O. Box 27511
--      Salt Lake City, UT 84127-0511, USA.
--
--   $Author: jsedwards $
--   $Date: 2009-08-07 07:42:54 -0600 (Fri, 07 Aug 2009) $
--   $Revision: 4303 $
--
--   NOTE: Subversion does not support the Log keyword so I have removed the
--   logs that were here when I was using CVS.  Use the "svn log" command to
--   see the revision history of this file.
--   (See http://subversion.tigris.org/faq.html#log-in-source)
--
--
--  Program to link together img*.jpg files with the same names.
--
--  ** WARNING ** this program breaks the file links ** DO NOT USE **
--
*/


#include <fnmatch.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#include "objectify_private.h"
#include "crc32.h"


static size_t get_path_object_size(void* file_path_obj)
{
    assert(((C_struct_File_Path*)file_path_obj)->count > 0);

    return sizeof(C_struct_File_Path) + ((C_struct_File_Path*)file_path_obj)->count;
}


int main(int argc, char* argv[])
{
    ObjRef root_object_ref;
    uint8 big_key[16 + 8 + 4];
    uint8 bf_key[16];
    uint32 linear;
    uint32 serial;
    C_struct_Class_Definition class_def_obj;
    C_struct_Path_And_File_Association old_assoc_obj;
    C_struct_Path_And_File_Association new_assoc_obj;
    C_struct_File old_file;
    C_struct_File new_file;
    uint8 kludge[FILE_BLOCK_SIZE];
    C_struct_File_Path* ptr_path_obj = (C_struct_File_Path*)kludge;
    ObjRef path_class_ref;
    ObjRef object_class;
    ObjRef assoc_class_ref;
    ReferenceList* path_list;
    ReferenceList* ref_list;
    int num_paths;
    int num_refs;
    int num_files = 0;
    int argn;
    int i;
    int j;
    char name[256];
    bool error = false;


    StorageType type = DEFAULT_TYPE_RW;
    char* path = DEFAULT_FILE;

    argn = 1;

    if (argc != 1)
    {
	fprintf(stderr, "No arguments at this time...\n");
	exit(1);
    }

#if 0
    while (argn < argc && *argv[argn] == '-')
    {
	if (strcmp(argv[argn], "--compressed") == 0 && argc > argn + 1)
	{
	    type = Compressed_File_RO;
	    argn++;
	    path = argv[argn];
	    argn++;
	}
	else if (strcmp(argv[argn], "--md5") == 0)
	{
	    do_md5 = true;
	    argn++;
	}
	else if (strcmp(argv[argn], "--sha1") == 0)
	{
	    do_sha1 = true;
	    argn++;
	}
	else
	{
	    fprintf(stderr, "usage: %s [--compressed compressed-file] [--md5] [--sha1] files to extract\n", argv[0]);
	    exit(1);
	}

    }
#endif


    printf("\n");

    nwos_get_key_from_password(big_key, sizeof(big_key));

    memcpy(bf_key, big_key, 16);
    linear = ((uint32)big_key[16] << 24) | ((uint32)big_key[17] << 16) | ((uint32)big_key[18] << 8) | (uint32)big_key[19];
    memcpy(root_object_ref.id, big_key+20, 4);
    serial = ((uint32)big_key[24] << 24) | ((uint32)big_key[25] << 16) | ((uint32)big_key[26] << 8) | (uint32)big_key[27];

    nwos_initialize_objectify(bf_key, linear, serial, type, path);

    nwos_set_root_object(&root_object_ref);


    assert(nwos_find_private_class_definition("FILE PATH", &path_class_ref));

    assert(nwos_find_private_class_definition("PATH AND FILE ASSOCIATION", &assoc_class_ref));

    nwos_read_class_definition(&path_class_ref, &class_def_obj);

    path_list = nwos_malloc_reference_list(&class_def_obj.header.object.references);

    num_paths = path_list->common_header.num_refs;

    printf("num_paths: %d\n", num_paths);

    for (i = 0; i < num_paths && !error; i++)
    {
	nwos_get_object_class(&path_list->references[i], &object_class);

	if (is_same_object(&object_class, &path_class_ref))
	{
	    assert(nwos_read_variable_sized_object_from_disk(&path_list->references[i], kludge, sizeof(kludge), &get_path_object_size));

	    /* remember ptr_path_obj points to the kludge buffer */

	    for (j = 0; j < ptr_path_obj->count; j++) name[j] = ptr_path_obj->storage[j];

	    name[j] = '\0';

	    if (name[0] == 'i' && name[1] == 'm' && name[2] == 'g' && name[3] == '_' &&
		name[8] == '.' && name[9] == 'j' && name[10] == 'p' && name[11] == 'g')
	    {
		ref_list = nwos_malloc_reference_list(&ptr_path_obj->header.object.references);

		num_refs = ref_list->common_header.num_refs;

		if (num_refs > 1)
		{
		    nwos_get_object_class(&ref_list->references[0], &object_class);
		    assert(is_same_object(&object_class, &assoc_class_ref));

		    nwos_get_object_class(&ref_list->references[1], &object_class);
		    assert(is_same_object(&object_class, &assoc_class_ref));

		    assert(nwos_read_object_from_disk(&ref_list->references[0], &old_assoc_obj, sizeof(old_assoc_obj)));
		    assert(nwos_read_object_from_disk(&ref_list->references[1], &new_assoc_obj, sizeof(new_assoc_obj)));

		    assert(nwos_read_object_from_disk(&old_assoc_obj.file, &old_file, sizeof(old_file)));
		    assert(nwos_read_object_from_disk(&new_assoc_obj.file, &new_file, sizeof(new_file)));

		    printf("%s: %d\n", name, num_refs);

		    if (is_void_reference(&old_file.header.object.next_version) ||
			is_void_reference(&new_file.header.object.prev_version))
		    {
			if (!is_void_reference(&old_file.header.object.next_version))
			{
			    fprintf(stderr, "ERROR: old file: %08x already has next: %08x.\n",
				    nwos_ref_to_word(&old_assoc_obj.file),
				    nwos_ref_to_word(&old_file.header.object.next_version));
			    error = true;
			}

			if (!is_void_reference(&new_file.header.object.prev_version))
			{
			    fprintf(stderr, "ERROR: new file: %08x already has previous: %08x.\n",
				    nwos_ref_to_word(&new_assoc_obj.file),
				    nwos_ref_to_word(&new_file.header.object.prev_version));
			    error = true;
			}

			if (!error)
			{
			  --->> NOTE: the following two lines are broken, they link back to the assoc object! <<---
			  --->> See bug #1957144 <<---

			    copy_reference(&old_file.header.object.next_version, &ref_list->references[1]);
			    copy_reference(&new_file.header.object.prev_version, &ref_list->references[0]);

			    nwos_crc32_calculate((uint8*) &old_file.header.object, sizeof(ObjectHeader), old_file.header.common.header_chksum);
			    nwos_crc32_calculate((uint8*) &new_file.header.object, sizeof(ObjectHeader), new_file.header.common.header_chksum);

			    nwos_overwrite_object_to_disk(&old_assoc_obj.file, &old_file, sizeof(old_file));
			    nwos_overwrite_object_to_disk(&new_assoc_obj.file, &new_file, sizeof(new_file));
			    printf("linked - old: %08x and new: %08x\n",
				   nwos_ref_to_word(&old_assoc_obj.file),
				   nwos_ref_to_word(&new_assoc_obj.file));
			}
		    }
		    else
		    {
			if (!is_same_object(&old_file.header.object.next_version, &ref_list->references[1]))
			{
			    fprintf(stderr, "ERROR: old file: %08x doesn't point to new file %08x,\n",
				    nwos_ref_to_word(&old_assoc_obj.file),
				    nwos_ref_to_word(&ref_list->references[1]));
			    fprintf(stderr, "instead poins to: %08x.\n",
				    nwos_ref_to_word(&old_file.header.object.next_version));
			    error = true;
			}

			else if (!is_same_object(&new_file.header.object.prev_version, &ref_list->references[0]))
			{
			    fprintf(stderr, "ERROR: new file: %08x doesn't point to old file %08x,\n",
				    nwos_ref_to_word(&new_assoc_obj.file),
				    nwos_ref_to_word(&ref_list->references[0]));
			    fprintf(stderr, "instead poins to: %08x.\n",
				    nwos_ref_to_word(&new_file.header.object.prev_version));
			    error = true;
			}

			else
			{
			    printf("already linked - old: %08x and new: %08x\n",
				   nwos_ref_to_word(&old_assoc_obj.file),
				   nwos_ref_to_word(&new_assoc_obj.file));
			}
		    }

		    nwos_free_reference_list(ref_list);
		    ref_list = NULL;

		    num_files++;
		}
	    }
	    //    memcpy(file_ref, &ptr_path_obj->file, sizeof(*file_ref));
	}
    }

    printf("Number of files: %d\n", num_files);

    nwos_free_reference_list(path_list);
    path_list = NULL;

    nwos_terminate_objectify();

    return 0;
}


