#
#          This file is part of the New World OS and Objectify projects
#                        Copyright (C) 2009  QRW Software
#               J. Scott Edwards - j.scott.edwards.nwos@gmail.com 
#
#   This program is free software: you can redistribute it and/or modify
#   it under the terms of the GNU General Public License as published by
#   the Free Software Foundation, either version 3 of the License, or
#   (at your option) any later version.
#
#   This program is distributed in the hope that it will be useful,
#   but WITHOUT ANY WARRANTY; without even the implied warranty of
#   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#   GNU General Public License for more details.
#
#   You should have received a copy of the GNU General Public License
#   along with this program, in the file LICENSE.  If not, see 
#   <http://www.gnu.org/licenses/>.
#
#   For the latest information, source code (SVN), releases, bug and feature
#   request tracking go to:
#      http://sourceforge.net/projects/objectify
#
#   For older bug tracking, releases and source code (CVS) prior to the
#   Alpha_30 release go to:
#      http://sourceforge.net/projects/nwos
#
#   Other related websites:
#      http://www.qrwsoftware.com
#      http://www.worldwide-database.org
#
#   You can also contact me via paper mail at:
#
#      QRW Software
#      P.O. Box 27511
#      Salt Lake City, UT 84127-0511, USA.
#
#   $Author: jsedwards $
#   $Date: 2009-08-15 07:29:25 -0600 (Sat, 15 Aug 2009) $
#   $Revision: 4336 $
#
#   NOTE: Subversion does not support the Log keyword so I have removed the
#   logs that were here when I was using CVS.  Use the "svn log" command to
#   see the revision history of this file.
#   (See http://subversion.tigris.org/faq.html#log-in-source)
# 


export OBJECTIFY_TEST_ONLY_DO_NOT_USE="Diff Compressed Test"
export OBJECTIFY_PRIVATE_PATH=/tmp/objectify_test/private.obj
export OBJECTIFY_LOG_FILE_PATH=/tmp/objectify_test/objectify_log
export OBJECTIFY_BACKUP_PATH=/tmp/objectify_test

EXEC=$PWD

if ! rm -fr /tmp/objectify_test; then
   echo ""
   echo "could not remove /tmp/objectify_test directory"
   echo ""
   exit 1
fi

if ! rm -fr /tmp/test; then
   echo ""
   echo "could not remove /tmp/objectify_test directory"
   echo ""
   exit 1
fi


mkdir /tmp/test
cd /tmp/test

echo "----------------------"
echo " creating test files"
echo "----------------------"

#dd if=/dev/random of=x7 bs=7 count=1

echo "WARNING: NOT using random data!!!!!"
echo -n "1234567" > x7

cat          x7          x7 >        x14
cat         x14         x14 >        x28
cat         x28         x28 >        x56
cat         x56         x56 >       x112
cat        x112        x112 >       x224
cat        x224        x224 >       x448
cat        x448        x448 >       x896
cat        x896        x896 >      x1792
cat       x1792       x1792 >      x3584
cat       x3584       x3584 >      x7168
cat       x7168       x7168 >     x14336
cat      x14336      x14336 >     x28672
cat      x28672      x28672 >     x57344
cat      x57344      x57344 >    x114688
cat     x114688     x114688 >    x229376
cat     x229376     x229376 >    x458752
cat     x458752     x458752 >    x917504
cat     x917504     x917504 >   x1835008
cat    x1835008    x1835008 >   x3670016
cat    x3670016    x3670016 >   x7340032
cat    x7340032    x7340032 >  x14680064
cat   x14680064   x14680064 >  x29360128


echo "---------------"
echo " prep disk..."
echo "---------------"
if ! $EXEC/src/apps/util/prep_disk; then
   echo ""
   echo "prep_disk failed"
   echo ""
   exit 1
fi

mkdir /tmp/objectify_test/save
mv -i /tmp/objectify_test/*.dif  /tmp/objectify_test/save

sleep 2

echo "---------------------"
echo " compress before..."
echo "---------------------"
if ! $EXEC/src/apps/util/compress_archive /tmp/objectify_test/compressed-before; then
   echo ""
   echo "compress_archive failed"
   echo ""
   exit 1
fi

sleep 2

echo "---------------"
echo " import_files..."
echo "---------------"
if ! $EXEC/src/apps/file/import_file x1*; then
   echo ""
   echo "import_file failed"
   echo ""
   exit 1
fi

sleep 1

if ! $EXEC/src/apps/file/import_file x2*; then
   echo ""
   echo "import_file failed"
   echo ""
   exit 1
fi

sleep 1

if ! $EXEC/src/apps/file/import_file x3*; then
   echo ""
   echo "import_file failed"
   echo ""
   exit 1
fi

sleep 1

if ! $EXEC/src/apps/file/import_file x4*; then
   echo ""
   echo "import_file failed"
   echo ""
   exit 1
fi

sleep 1

if ! $EXEC/src/apps/file/import_file x5*; then
   echo ""
   echo "import_file failed"
   echo ""
   exit 1
fi

sleep 1

if ! $EXEC/src/apps/file/import_file x7*; then
   echo ""
   echo "import_file failed"
   echo ""
   exit 1
fi

sleep 1

if ! $EXEC/src/apps/file/import_file x8*; then
   echo ""
   echo "import_file failed"
   echo ""
   exit 1
fi

sleep 1

if ! $EXEC/src/apps/file/import_file x9*; then
   echo ""
   echo "import_file failed"
   echo ""
   exit 1
fi

sleep 2


echo "---------------------"
echo " compress after..."
echo "---------------------"
if ! $EXEC/src/apps/util/compress_archive /tmp/objectify_test/compressed-after; then
   echo ""
   echo "compress_archive failed"
   echo ""
   exit 1
fi

sleep 2


echo "---------------------"
echo " diff compressed..."
echo "---------------------"
if ! $EXEC/src/apps/util/diff_compressed /tmp/objectify_test/compressed-before /tmp/objectify_test/compressed-after /tmp/objectify_test/diff-before-after > /tmp/objectify_test/diff-before-after.txt; then
   echo ""
   echo "diff_compressed failed"
   echo ""
   exit 1
fi

sleep 2


echo "---------------------"
echo " combine backups..."
echo "---------------------"
if ! $EXEC/src/apps/util/combine_backup_files /tmp/objectify_test/*.dif /tmp/objectify_test/combined-before-after; then
   echo ""
   echo "combine_backup_files failed"
   echo ""
   exit 1
fi

sleep 2


echo "-------------------------------------------"
echo " verify diff and combined are the same..."
echo "-------------------------------------------"
if ! diff -s /tmp/objectify_test/diff-before-after /tmp/objectify_test/combined-before-after; then
   echo ""
   echo "combined and diff files differ"
   echo ""
   exit 1
fi

sleep 2


echo "---------------------"
echo " patch compressed..."
echo "---------------------"
if ! $EXEC/src/apps/util/patch_compressed /tmp/objectify_test/compressed-before /tmp/objectify_test/combined-before-after /tmp/objectify_test/patched-after > /tmp/objectify_test/patched-after.txt; then
   echo ""
   echo "patch_compressed failed"
   echo ""
   exit 1
fi

sleep 2



echo "-------------------------------------------"
echo " verify diff and combined are the same..."
echo "-------------------------------------------"
if ! diff -s /tmp/objectify_test/compressed-after /tmp/objectify_test/patched-after; then
   echo ""
   echo "compressed and patched files differ"
   echo ""
   exit 1
fi

sleep 2



echo "--------------------------"
echo " prep disk for restore..."
echo "--------------------------"
if ! $EXEC/src/apps/util/prep_disk --no-private; then
   echo ""
   echo "prep_disk --no-private failed"
   echo ""
   exit 1
fi


echo "---------------------"
echo " expand..."
echo "---------------------"
if ! $EXEC/src/apps/util/restore_archive /tmp/objectify_test/patched-after; then
   echo ""
   echo "restore_archive failed"
   echo ""
   exit 1
fi



if ! $EXEC/src/apps/file/export_file "*"; then
   echo ""
   echo "export_file failed"
   echo ""
   exit 1
fi

for file in ../*.[ch]; do diff -s $file .; done


echo "---------------------"
echo " verify and remove..."
echo "---------------------"
if ! $EXEC/src/apps/file/verify_file --remove-no-shred *; then
   echo ""
   echo "verify_file --remove-no-shred failed"
   echo ""
   exit 1
fi



echo "---------------------------"
echo " prep a second archive..."
echo "---------------------------"

if ! $EXEC/src/apps/util/prep_disk --no-private /tmp/objectify_test/private2.obj; then
   echo ""
   echo "prep_disk failed"
   echo ""
   exit 1
fi

sleep 2


echo "---------------------"
echo " sync archive..."
echo "---------------------"
if ! $EXEC/src/apps/util/sync_archive /tmp/objectify_test/private2.obj; then
   echo ""
   echo "sync_archive failed"
   echo ""
   exit 1
fi

sleep 2


echo "------------------------------"
echo " compress second archive..."
echo "------------------------------"

export OBJECTIFY_PRIVATE_PATH=/tmp/objectify_test/private2.obj

if ! $EXEC/src/apps/util/compress_archive /tmp/objectify_test/compressed-second; then
   echo ""
   echo "compress_archive failed"
   echo ""
   exit 1
fi


sleep 2

echo "-----------------------------------------------------"
echo " verify first and second compressed are the same..."
echo "-----------------------------------------------------"
if ! $EXEC/src/apps/util/diff_compressed /tmp/objectify_test/compressed-after /tmp/objectify_test/compressed-second; then
   echo ""
   echo "first and second compressed files differ"
   echo ""
   exit 1
fi

echo "PLEASE check above that there were no differences!"

sleep 5


echo "---------------------------"
echo " prep a third archive..."
echo "---------------------------"

if ! $EXEC/src/apps/util/prep_disk --no-private /tmp/objectify_test/private3.obj; then
   echo ""
   echo "prep_disk failed"
   echo ""
   exit 1
fi

sleep 2


echo "---------------------"
echo " sync archive..."
echo "---------------------"
if ! $EXEC/src/apps/util/sync_archive /tmp/objectify_test/private2.obj /tmp/objectify_test/private3.obj; then
   echo ""
   echo "sync_archive failed"
   echo ""
   exit 1
fi

sleep 2


echo "------------------------------"
echo " compress third archive..."
echo "------------------------------"

export OBJECTIFY_PRIVATE_PATH=/tmp/objectify_test/private3.obj

if ! $EXEC/src/apps/util/compress_archive /tmp/objectify_test/compressed-third; then
   echo ""
   echo "compress_archive failed"
   echo ""
   exit 1
fi


sleep 2

echo "-----------------------------------------------------"
echo " verify first and third compressed are the same..."
echo "-----------------------------------------------------"
if ! $EXEC/src/apps/util/diff_compressed /tmp/objectify_test/compressed-after /tmp/objectify_test/compressed-third; then
   echo ""
   echo "first and third compressed files differ"
   echo ""
   exit 1
fi

echo "PLEASE check above that there were no differences!"

sleep 5


echo "---------------------------"
echo " prep a fourth archive..."
echo "---------------------------"

if ! $EXEC/src/apps/util/prep_disk /tmp/objectify_test/private4.obj; then
   echo ""
   echo "prep_disk failed"
   echo ""
   exit 1
fi

sleep 2


echo "-----------------------------------"
echo " expand into non-empty archive..."
echo "-----------------------------------"

export OBJECTIFY_PRIVATE_PATH=/tmp/objectify_test/private4.obj

if $EXEC/src/apps/util/restore_archive /tmp/objectify_test/patched-after; then
   echo ""
   echo "restore_archive into non-empty archive succeeded"
   echo ""
   exit 1
fi

sleep 2


echo "------------------------------------------"
echo " sync archive into non-empty archive..."
echo "------------------------------------------"
if $EXEC/src/apps/util/sync_archive /tmp/objectify_test/private3.obj /tmp/objectify_test/private4.obj; then
   echo ""
   echo "sync_archive into non-empty archive succeeded"
   echo ""
   exit 1
fi

sleep 2


echo "------------------------------------------"
echo " sync archive with duplicate path..."
echo "------------------------------------------"
if $EXEC/src/apps/util/sync_archive /tmp/objectify_test/private4.obj; then
   echo ""
   echo "sync_archive with duplicate path succeeded"
   echo ""
   exit 1
fi

sleep 2

echo "------------------------------------------"
echo " sync archive with duplicate paths..."
echo "------------------------------------------"
if $EXEC/src/apps/util/sync_archive /tmp/objectify_test/private3.obj /tmp/objectify_test/private3.obj; then
   echo ""
   echo "sync_archive with duplicate paths succeeded"
   echo ""
   exit 1
fi



echo ""
echo "All tests passed!"
echo ""


exit 0

