--
--          This file is part of the New World OS and Objectify projects
--                  Copyright (C) 2006, 2007, 2009  QRW Software
--               J. Scott Edwards - j.scott.edwards.nwos@gmail.com 
--
--   This program is free software: you can redistribute it and/or modify
--   it under the terms of the GNU General Public License as published by
--   the Free Software Foundation, either version 3 of the License, or
--   (at your option) any later version.
--
--   This program is distributed in the hope that it will be useful,
--   but WITHOUT ANY WARRANTY; without even the implied warranty of
--   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
--   GNU General Public License for more details.
--
--   You should have received a copy of the GNU General Public License
--   along with this program, in the file LICENSE.  If not, see 
--   <http://www.gnu.org/licenses/>.
--
--   For the latest information, source code (SVN), releases, bug and feature
--   request tracking go to:
--      http://sourceforge.net/projects/objectify
--
--   For older bug tracking, releases and source code (CVS) prior to the
--   Alpha_30 release go to:
--      http://sourceforge.net/projects/nwos
--
--   Other related websites:
--      http://www.qrwsoftware.com
--      http://www.worldwide-database.org
--
--   You can also contact me via paper mail at:
--
--      QRW Software
--      P.O. Box 27511
--      Salt Lake City, UT 84127-0511, USA.
--
--   $Author: jsedwards $
--   $Date: 2009-08-07 07:42:54 -0600 (Fri, 07 Aug 2009) $
--   $Revision: 4303 $
--
--   NOTE: Subversion does not support the Log keyword so I have removed the
--   logs that were here when I was using CVS.  Use the "svn log" command to
--   see the revision history of this file.
--   (See http://subversion.tigris.org/faq.html#log-in-source)
--


class CLASS_DEFINITION

inherit GLOBALS
        REFERENCE_COUNTER

creation make, make_from_csv

feature

   reference: UNSIGNED

   reference_list: REFERENCE_LIST

   name: NAME

   features: FIXED_ARRAY[FEATURE_DEFINITION]

   make is
      do
         !!features.with_capacity(8)

         reference := next_reference

         !!reference_list.make

         all_classes.add_last(Current)
      end

   put_name(class_name: STRING) is
      require
         name = Void
      do
         name := find_name(class_name)

         if name = Void then
            !!name.make(class_name)
         end

         name.reference_list.add_reference(reference)

         class_def_class_def.reference_list.add_reference(reference)
      end

   add_feature(feat_def: FEATURE_DEFINITION) is
      do
         features.add_last(feat_def)

         feat_def.reference_list.add_reference(reference)
      end


   make_from_csv(line: STRING) is
      local
         dummy: UNSIGNED
      do
         !!features.with_capacity(4)

         reference := scan_reference(line)

         check_comma(line)

         skip_time(line)

         check_comma(line)

         dummy := scan_reference(line)   -- ignore class for now

         check_comma(line)

         dummy := scan_reference(line)   -- ignore refernce list for now

         check_comma(line)

         dummy := scan_reference(line)   -- read name reference

         name := find_name_from_reference(dummy)

         from
         until
            line.is_empty
         loop
            check_comma(line)

            dummy := scan_reference(line)  -- read feature reference

            features.add_last(find_feature_from_reference(dummy))
         end
      end

end

