--
--          This file is part of the New World OS and Objectify projects
--                  Copyright (C) 2006, 2007, 2009  QRW Software
--               J. Scott Edwards - j.scott.edwards.nwos@gmail.com 
--
--   This program is free software: you can redistribute it and/or modify
--   it under the terms of the GNU General Public License as published by
--   the Free Software Foundation, either version 3 of the License, or
--   (at your option) any later version.
--
--   This program is distributed in the hope that it will be useful,
--   but WITHOUT ANY WARRANTY; without even the implied warranty of
--   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
--   GNU General Public License for more details.
--
--   You should have received a copy of the GNU General Public License
--   along with this program, in the file LICENSE.  If not, see 
--   <http://www.gnu.org/licenses/>.
--
--   For the latest information, source code (SVN), releases, bug and feature
--   request tracking go to:
--      http://sourceforge.net/projects/objectify
--
--   For older bug tracking, releases and source code (CVS) prior to the
--   Alpha_30 release go to:
--      http://sourceforge.net/projects/nwos
--
--   Other related websites:
--      http://www.qrwsoftware.com
--      http://www.worldwide-database.org
--
--   You can also contact me via paper mail at:
--
--      QRW Software
--      P.O. Box 27511
--      Salt Lake City, UT 84127-0511, USA.
--
--   $Author: jsedwards $
--   $Date: 2009-07-25 17:25:15 -0600 (Sat, 25 Jul 2009) $
--   $Revision: 4184 $
--
--   NOTE: Subversion does not support the Log keyword so I have removed the
--   logs that were here when I was using CVS.  Use the "svn log" command to
--   see the revision history of this file.  I have kept the portion of the
--   old CVS log before this file was moved from the main directory.
--   (See http://subversion.tigris.org/faq.html#log-in-source)
--
--
-- Revision 1.4  2006/11/11 12:29:19  jsedwards
-- Update e-mail address to something that works.
--
-- Revision 1.3  2006/02/19 19:07:06  jsedwards
-- Wrapped debug print statement when object read in, in "debug" so they only
-- print when debug is passed to compiler.
--
-- Revision 1.2  2006/02/19 18:07:53  jsedwards
-- Changed so "load" routine can only be run by "load_if_not_already".
--
-- Revision 1.1  2006/02/19 15:55:18  jsedwards
-- Changed the name of NWOS_HEADER to NWOS_OBJECT.
--
-- Revision 1.28  2006/02/18 15:41:36  jsedwards
-- Added "ensure" clauses to "initialize header" and "read header" routines
-- so they make sure none of the stuff is void that shouldn't be.
--
-- Revision 1.27  2006/02/18 14:03:18  jsedwards
-- Removed "Reference_size" as it doesn't seem to be used anywhere.
-- Changed all of the attributes that are accessable externally to routines
-- that check to make sure the object has been loaded before returning the
-- object.  This way they objects don't have to be loaded (resolved) unless
-- they are actually used.
--
-- Revision 1.26  2006/02/16 02:57:54  jsedwards
-- Commented out some of the debugging print statements.
--
-- Revision 1.25  2006/02/13 04:34:07  jsedwards
-- Deleted lines to print "generator" and "generating_type" in initialize
-- header.  Commented out debugging print statements in "make_unresolved".
--
-- Revision 1.24  2006/02/11 15:24:10  jsedwards
-- Eliminated "once" temp_ref variable and used a separately created variable
-- for each of the class, log, and grade references.  Also added printing of
-- the time stamp and other stuff for debugging purposes.
--
-- Revision 1.23  2006/02/11 12:39:32  jsedwards
-- Added print statement to make_unresolved.
--
-- Revision 1.22  2006/02/10 20:21:16  jsedwards
-- Fixed bug where it was reading the "grade" object into the "log".
-- Commented out the checking the name of the class in "load" because it
-- may not be valid yet.  Added some more information to void error exits
-- in read_header.
--
-- Revision 1.21  2006/02/10 14:23:40  jsedwards
-- Changed so that reference.load creates an unresolved object first, and puts
-- it into the cache before loading it.  This means if reference.load is
-- called again recursively, the object is already in the cache and can be
-- returned without trying to create a new (duplicate) object and it doesn't
-- get stuck in an infinite recursive loop.
--
-- Revision 1.20  2006/02/10 05:01:14  jsedwards
-- Changed to load log and grade objects.
--
-- Revision 1.19  2006/02/10 02:05:20  jsedwards
-- Changed "log" and "grade" features to actuall attributes instead of "once"
-- features.
--
-- Revision 1.18  2006/02/09 05:49:10  jsedwards
-- Change so that each new object is put into the reference cache.
--
-- Revision 1.17  2006/02/09 05:42:21  jsedwards
-- Changes to allow objects to both be created and to be loaded.
--
-- Revision 1.16  2006/02/08 19:56:23  jsedwards
-- Added another comment about why this won't work as is.
--
-- Revision 1.15  2006/02/08 19:53:06  jsedwards
-- Changed to read object class definition and then compare to the current
-- class definition.
--
-- Revision 1.14  2006/02/08 19:29:05  jsedwards
-- Fixed to read in the class definition reference and then compare it to the
-- current class definiton ref.  This doesn't work.
--
-- Revision 1.13  2006/02/08 14:26:25  jsedwards
-- Added features to load a class in, they are incomplete at this point.
--
-- Revision 1.12  2006/02/06 14:16:45  jsedwards
-- Started adding read from stream, incomplete, won't compile!
--
-- Revision 1.11  2006/02/05 03:27:01  jsedwards
-- Changed header version to 0010 and made user, log, grade (was status) real
-- objects.
--
-- Revision 1.10  2006/02/04 15:40:15  jsedwards
-- Added test to make sure file doesn't already exist.
--
-- Revision 1.9  2006/02/04 15:09:38  jsedwards
-- Changed to new deferred class defintion and to create the class definition
-- when initialize header is called.
--
-- Revision 1.8  2006/02/04 03:48:48  jsedwards
-- Put "class ref" back in (was setting all objects to binary code class).
--
-- Revision 1.7  2006/02/03 14:25:50  jsedwards
-- Changed app reference to big_bang_03.
--
-- Revision 1.6  2006/02/03 03:14:50  jsedwards
-- Changed to header version 0009 and minor changes (Big_Bang_02).
--
-- Revision 1.5  2006/02/02 06:04:50  jsedwards
-- Kludged version just used to create class_definition class object.
--
-- Revision 1.4  2006/01/31 14:24:26  jsedwards
-- New data layout format (0008).
--
-- Revision 1.3  2006/01/29 18:08:40  jsedwards
-- Added code to set the output file type to big endian so that we can write
-- data values larger than 1 byte and they will come out correctly.
-- Changed so that instead of redefining write_to_stream, there is a deferred
-- feature that writes the body of the object to stream.
--
-- Revision 1.2  2006/01/29 00:30:44  jsedwards
-- First working version.
--
-- Revision 1.1  2006/01/25 13:44:14  jsedwards
-- Incomplete version, saving in CVS as back up.
--

deferred class NWOS_OBJECT

inherit NWOS_PREDEFINED_REFERENCES
        NWOS_SESSION   -- access to the session log created by the app

  -- header of all reference objects (not included in expanded objects)


feature

   Current_header_version: STRING is
      once
         Result := "0010"
         Result.set_immutable(key)
      end

   header_version: STRING is
      do
         load_if_not_already
         Result := header_version_str
      ensure
         Result /= Void
      end

   time_stamp: NWOS_TIME_STAMP is
      do
         load_if_not_already
         Result := time_stamp_obj
      ensure
         Result /= Void
      end
     

   identifier: NWOS_REFERENCE            --  this is always non-void (class invariant)
     

   class_definition: NWOS_CLASS_DEFINITION is
      do
         load_if_not_already
         Result := class_def_obj
      ensure
         Result /= Void
      end


   log: NWOS_SESSION_LOG is
      do
         load_if_not_already
         Result := log_obj
      ensure
         Result /= Void
      end


   grade: NWOS_OBJECT_GRADE is
      do
         load_if_not_already
         Result := grade_obj
      ensure
         Result /= Void
      end



   Signature_size: INTEGER is 65


   store is
      require
         not identifier.is_void
      local
         path: STRING
      do
         path := string_pool.item(identifier.path_size)

         identifier.path(path)

std_output.put_string(path)
std_output.put_new_line
std_output.flush

         output_file.make(path)

         if output_file.exists then
            std_error.put_string("File already exists: ")
            std_error.put_string(path)
            std_error.put_new_line
            die_with_code(exit_failure_code)
         end

         output_file.set_big_endian
         output_file.open

         write_header_to_stream(output_file)

         write_body_to_stream(output_file)

--         write_signature_to_stream(output_file)

         output_file.close

         string_pool.put(path)
      end


feature {NONE}  -- only allow this to be called by load_if_not_already

   load is
      local
         path: STRING
         input_file: BINARY_FILE_READ
      do
         path := string_pool.item(identifier.path_size)

         identifier.path(path)
debug
std_output.put_string(path)
std_output.put_new_line
std_output.flush
end
         input_file := get_unused_input_file
         input_file.make(path)

         if not input_file.exists then
            std_error.put_string("File doesn't exist:")
            std_error.put_string(path)
            std_error.put_new_line
            die_with_code(exit_failure_code)
         end

         input_file.set_big_endian
         input_file.open

         read_header_from_stream(input_file)

         read_body_from_stream(input_file)

--         write_signature_to_stream(input_file)

         input_file.close

         string_pool.put(path)

--         std_output.put_string("class name: ")
--         std_output.put_string(class_def_obj.name.storage)
--         std_output.put_new_line

--         if not class_def_obj.name.storage.is_equal(generator) then
--            std_error.put_string("Error: class mismatch:")
--            std_error.put_string("%N   object: ")
--            std_error.put_string(class_def_obj.name.storage)
--            std_error.put_string("%N   class:  ")
--            std_error.put_string(generator)
--            std_error.put_new_line
--            die_with_code(exit_failure_code)
--         end
      end

   write_header_to_stream(stream: BINARY_OUTPUT_STREAM) is
      do
         stream.put_string("NWOS")

         stream.put_string(header_version_str)

         time_stamp_obj.write_to_stream(stream)

         identifier.write_to_stream(stream)

         class_def_obj.identifier.write_to_stream(stream)

         log_obj.identifier.write_to_stream(stream)

         grade_obj.identifier.write_to_stream(stream)
      end

   write_body_to_stream(stream: BINARY_OUTPUT_STREAM) is
      deferred
      end

   read_header_from_stream(stream: BINARY_INPUT_STREAM) is
      local
         magic_number: STRING
--         temp_str: STRING
         id: NWOS_REFERENCE   -- identifier read from file
         class_ref: NWOS_REFERENCE
         log_ref: NWOS_REFERENCE
         grade_ref: NWOS_REFERENCE
      do
         !!magic_number.make(4)
         stream.read_string_in(magic_number, magic_number.capacity)

       -- fix this, it needs to be handled more elegantly

         if not magic_number.is_equal("NWOS") then
            std_error.put_string("Error: file missing magic number (%"NWOS%").%N")
            die_with_code(exit_failure_code)
         end

         !!header_version_str.make(4)
         stream.read_string_in(header_version_str, header_version.capacity)

         if not header_version.is_equal(Current_header_version) then
            std_error.put_string("Error: this version can't read an object with version: ")
            std_error.put_string(header_version_str)
            std_error.put_new_line
            die_with_code(exit_failure_code)
         end

         !!time_stamp_obj.make
         time_stamp_obj.read_from_stream(stream)

debug
   temp_str := string_pool.item(128)

   time_stamp_obj.append_in(temp_str)
   std_output.put_string(temp_str)
   std_output.put_new_line
end

         !!id.make_from_stream(stream)
debug
   std_output.put_string(id.to_string)
   std_output.put_new_line
   std_output.flush
end

         if not id.is_equal(identifier) then
            std_error.put_string("identifier mismatch:")
            std_error.put_string("%N   current id: ")
            std_error.put_string(identifier.to_string)
            std_error.put_string("%N   file id:    ")
            std_error.put_string(id.to_string)
            std_error.put_new_line
            die_with_code(exit_failure_code)
         end

         -- If this system were all integrated the way it should be, we would read the class definition
         -- here and use that class to read in the object.  In this kludged world where the class
         -- definition is really in a file external to the system, the best we can do is to read the
         -- version of the file that created the object and give that to the class and hopefully it
         -- can cope with it properly.

         !!class_ref.make_from_stream(stream)

         if class_ref.is_equal(identifier) then  -- this is the class definition object, which refers to itself
            class_def_obj ?= Current
         else
            class_def_obj ?= class_ref.get_object(Class_class_definition_ref)
         end

         if class_def_obj = Void then
            std_error.put_string("Error: void object class definition%N")
            std_error.put_string("  identifier: ")
            std_error.put_string(identifier.to_string)
            std_error.put_new_line
            die_with_code(exit_failure_code)
         end

         !!log_ref.make_from_stream(stream)

         log_obj ?= log_ref.get_object(Class_session_log_ref)

         if log_obj = Void then
            std_error.put_string("Error: void session log%N")
            std_error.put_string("  identifier: ")
            std_error.put_string(identifier.to_string)
            std_error.put_new_line
            die_with_code(exit_failure_code)
         end

         !!grade_ref.make_from_stream(stream)

         grade_obj ?= grade_ref.get_object(Class_object_grade_ref)

         if grade_obj = Void then
            std_error.put_string("Error: void object grade%N")
            std_error.put_string("  identifier: ")
            std_error.put_string(identifier.to_string)
            std_error.put_new_line
            die_with_code(exit_failure_code)
         end
debug
   string_pool.put(temp_str)
end
      ensure
         header_version_str /= Void
         time_stamp_obj /= Void
         class_def_obj /= Void
         log_obj /= Void
         grade_obj /= Void
      end

   read_body_from_stream(stream: BINARY_INPUT_STREAM) is
      deferred
      end


feature {NONE}

   key: INTEGER is Unique

   output_file: BINARY_FILE_WRITE is
      once
         !!Result.make(Void)
      end

   input_file_pool: FIXED_ARRAY[BINARY_FILE_READ] is
      once
         !!Result.with_capacity(16)
      end

   get_unused_input_file: BINARY_FILE_READ is
      local
         i: INTEGER
      do
         from
            i := input_file_pool.lower
         until
            i > input_file_pool.upper
               or else
            input_file_pool.item(i).is_closed
         loop
            i := i + 1
         end

         if i <= input_file_pool.upper then
            Result := input_file_pool.item(i)
         else
            !!Result.make(Void)
            input_file_pool.add_last(Result)
         end
      end

   initialize_header(id: NWOS_REFERENCE) is
      do
         id.put(Current)  -- put this new object into the cache
--std_output.put_string("initialize_header: ")
--std_output.put_string(id.out)
--std_output.put_new_line
--std_output.flush
         header_version_str := Current_header_version

         !!time_stamp_obj.now

         identifier := id

         if class_reference.has_object then
             class_def_obj ?= class_reference.object
             if class_def_obj = Void then
                std_error.put_string("class_definition is void%N")
                die_with_code(exit_failure_code)
             end
         else   -- this class hasn't been created yet
            !!class_def_obj.make(class_reference, generating_type, class_revision)
         end
         class_def_obj.add_reference(Current)

         log_obj := session_log
         if log_obj /= Current then  -- don't add the log to the log
            log.add_entry(Current)
         end

         grade_obj := session_grade
      ensure
         header_version_str /= Void
         time_stamp_obj /= Void
         class_def_obj /= Void
         log_obj /= Void
         grade_obj /= Void
      end


   make_unresolved(id: NWOS_REFERENCE) is
      do
--std_output.put_string("make_unresolved: ")
--std_output.put_string(generating_type)
--std_output.put_new_line
         identifier := id
      end


feature {NONE}  -- actual storage

   header_version_str: STRING

   time_stamp_obj: NWOS_TIME_STAMP

   class_def_obj: NWOS_CLASS_DEFINITION

   log_obj: NWOS_SESSION_LOG

   grade_obj: NWOS_OBJECT_GRADE


   load_if_not_already is
      do
         if header_version_str = Void then
            load
         end
      ensure
         header_version_str /= Void
      end


feature {NONE}

   class_reference: NWOS_REFERENCE is
      deferred
      end

   class_revision: STRING is
      deferred
      end

feature {NONE}

   next_nwos_identifier: NWOS_REFERENCE is
      do
         !!Result.copy(next_nwos_ref)
         next_nwos_ref.increment
      end

   next_latin_identifier: NWOS_REFERENCE is
      do
         !!Result.copy(next_latin_ref)
         next_latin_ref.increment
      end

   next_english_identifier: NWOS_REFERENCE is
      do
         !!Result.copy(next_english_ref)
         next_english_ref.increment
      end



invariant

   identifier /= Void

end

