/*
--          This file is part of the New World OS and Objectify projects
--               Copyright (C) 2006, 2007, 2008, 2009  QRW Software
--               J. Scott Edwards - j.scott.edwards.nwos@gmail.com 
--
--   This program is free software: you can redistribute it and/or modify
--   it under the terms of the GNU General Public License as published by
--   the Free Software Foundation, either version 3 of the License, or
--   (at your option) any later version.
--
--   This program is distributed in the hope that it will be useful,
--   but WITHOUT ANY WARRANTY; without even the implied warranty of
--   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
--   GNU General Public License for more details.
--
--   You should have received a copy of the GNU General Public License
--   along with this program, in the file LICENSE.  If not, see 
--   <http://www.gnu.org/licenses/>.
--
--   For the latest information, source code (SVN), releases, and bug tracking
--   go to:
--      http://savannah.nongnu.org/projects/objectify
--
--   For releases from Alpha_30 and up, bug and feature request tracking go to:
--      http://sourceforge.net/projects/objectify
--
--   For older bug tracking, releases and source code (CVS) prior to the
--   Alpha_30 release go to:
--      http://sourceforge.net/projects/nwos
--
--   Other related websites:
--      http://www.qrwsoftware.com
--      http://www.worldwide-database.org
--
--   You can also contact me via paper mail at:
--
--      QRW Software
--      P.O. Box 27511
--      Salt Lake City, UT 84127-0511, USA.
--
--   $Author: jsedwards $
--   $Date: 2010-01-21 05:54:56 -0700 (Thu, 21 Jan 2010) $
--   $Revision: 4470 $
--
--   NOTE: Subversion does not support the Log keyword so I have removed the
--   logs that were here when I was using CVS.  Use the "svn log" command to
--   see the revision history of this file and the log_disc.c file which this
--   file was derived from.
--   (See http://subversion.tigris.org/faq.html#log-in-source)
--
*/


#include <dirent.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <time.h>

#include "objectify.h"
#include "strlcxx.h"           /* in case strlcpy and strlcat are not provided by the system */


static char* file_names[MAX_FILES_PER_DISC_LIST];
static ObjRef files[MAX_FILES_PER_DISC_LIST];



int main(int argc, char* argv[])
{
    int i;
    char id[13];
    int num_files;
ObjRef disc_list_ref;
    bool missing_files = false;
#if 0
    bool bad_checksum = false;
    CheckFileResult check_file_result;
#endif
    uint8 kludge[MAX_SIZE_DISC_LIST];
    C_struct_Disc_List* ptr_list_obj = (C_struct_Disc_List*)kludge;
    DIR* dp;
    struct dirent *dir_entry;
    size_t name_size;

    if (argc != 2)
    {
	fprintf(stderr, "usage: %s directory\n", argv[0]);
	exit(1);
    }

    dp = opendir(argv[1]);
    if (dp == NULL)
    {
	perror(argv[1]);
	exit(1);
    }

    num_files = 0;
    dir_entry = readdir(dp);
    while (dir_entry != NULL)
    {
	if (strcmp(dir_entry->d_name, ".") != 0 && strcmp(dir_entry->d_name, "..") != 0)
	{
	    if (num_files == MAX_FILES_PER_DISC_LIST)
	    {
		fprintf(stderr, "Too many files in directory: %d, currently can only handle %d files max\n",
			num_files, MAX_FILES_PER_DISC_LIST);
		exit(1);
	    }

	    name_size = strlen(dir_entry->d_name) + 1;

	    file_names[num_files] = malloc(name_size);

	    if (file_names[num_files] == NULL)
	    {
		perror("allocating memory for file name");
		exit(1);
	    }

	    strlcpy(file_names[num_files], dir_entry->d_name, name_size);

	    /* printf("%s\n", file_names[num_files]); */

	    num_files++;
	}

	dir_entry = readdir(dp);
    }

    if (closedir(dp) != 0)
    {
	perror(argv[1]);
	exit(1);
    }

    printf("\n");

    nwos_log_arguments(argc, argv);

    nwos_initialize_objectify(READ_ONLY, DEFAULT_FILE);


    /* first verify that all the listed files are already in the system */

    memset(files, 0, sizeof(files));

    for (i = 0; i < num_files; i++)
    {
	printf("%s: ", file_names[i]);

	if (!nwos_find_matching_path_and_file_association(argv[1], file_names[i], &files[i], MatchAll))
	{
	    missing_files = true;
	}

	printf("\n");
    }

    if (missing_files)
    {
	printf("The following files are not in the system:\n\n");

	for (i = 0; i < num_files; i++)
	{
	    if (is_void_reference(&files[i]))
	    {
		printf("   %s\n", file_names[i]);
	    }
	}

	printf("\n");
	exit(1);
    }

    printf("\n");

    /* find and verify the disc */

    if (!nwos_find_matching_disc_list(files, &disc_list_ref))
    {
	printf("No matching disc list found!\n");
	exit(1);
    }

    assert(nwos_read_variable_sized_object_from_disk(&disc_list_ref, kludge, sizeof(kludge), &nwos_get_disc_list_object_size));

    memcpy(id, ptr_list_obj->id, sizeof(id) - 1);
    id[sizeof(id) - 1] = '\0';

    printf("disc list %02x%02x%02x%02x: %s\n",
	   disc_list_ref.id[0], disc_list_ref.id[1], disc_list_ref.id[2], disc_list_ref.id[3], id);

    for (i = 0; i < num_files; i++)
    {
	free(file_names[i]);
    }

    nwos_terminate_objectify();

    return 0;
}


