--
--          This file is part of the New World OS and Objectify projects
--                  Copyright (C) 2006, 2007, 2009  QRW Software
--               J. Scott Edwards - j.scott.edwards.nwos@gmail.com 
--
--   This program is free software: you can redistribute it and/or modify
--   it under the terms of the GNU General Public License as published by
--   the Free Software Foundation, either version 3 of the License, or
--   (at your option) any later version.
--
--   This program is distributed in the hope that it will be useful,
--   but WITHOUT ANY WARRANTY; without even the implied warranty of
--   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
--   GNU General Public License for more details.
--
--   You should have received a copy of the GNU General Public License
--   along with this program, in the file LICENSE.  If not, see 
--   <http://www.gnu.org/licenses/>.
--
--   For the latest information, source code (SVN), releases, and bug tracking
--   go to:
--      http://savannah.nongnu.org/projects/objectify
--
--   For releases from Alpha_30 and up, bug and feature request tracking go to:
--      http://sourceforge.net/projects/objectify
--
--   For older bug tracking, releases and source code (CVS) prior to the
--   Alpha_30 release go to:
--      http://sourceforge.net/projects/nwos
--
--   Other related websites:
--      http://www.qrwsoftware.com
--      http://www.worldwide-database.org
--
--   You can also contact me via paper mail at:
--
--      QRW Software
--      P.O. Box 27511
--      Salt Lake City, UT 84127-0511, USA.
--
--   $Author: jsedwards $
--   $Date: 2009-10-06 08:06:23 -0600 (Tue, 06 Oct 2009) $
--   $Revision: 4384 $
--
--   NOTE: Subversion does not support the Log keyword so I have removed the
--   logs that were here when I was using CVS.  Use the "svn log" command to
--   see the revision history of this file.
--   (See http://subversion.tigris.org/faq.html#log-in-source)
--


class CONVERT_C_STRUCTS_TO_CSV

inherit GLOBALS

creation make

feature

   Looking, Comment, Reading: INTEGER is unique;

   make is
      local
         line: STRING
         state: INTEGER
         i, j: INTEGER
         class_def: CLASS_DEFINITION
	 feature_def: FEATURE_DEFINITION
         name: NAME
         ref_list: REFERENCE_LIST
         hex_format: INTEGER_FORMAT
      do
         if class_def_class_def.reference /= 0x2 then
            std_error.put_string("Error Class definition is NOT reference 0x2%N")
            die_with_code(exit_failure_code)
         end

         !!in_file.connect_to("original_c_structs.h");

         if not in_file.is_connected then
            std_error.put_string("unable to open file: c_structs.h%N");
            die_with_code(exit_failure_code);
         end

         !!line.make(80)

         from
            state := Looking
            in_file.read_line_in(line)
         until
            in_file.end_of_input
         loop
            if line.count > 0 then
               feature_def := Void

               inspect
                  state
               when Looking then
                  if line.has_prefix("/*") then
                     state := Comment
                  elseif line.has_prefix("typedef struct {") then
                     !!class_def.make
                     state := Reading
                  else
                     std_error.put_string("Invalid line while searching for typedef: ");
                     std_error.put_string(line);
                     std_error.put_new_line;
                     die_with_code(exit_failure_code)
                  end
               when Comment then
                  if line.has_suffix("*/") then
                     state := Looking
                  end
               when Reading then
                  if line.has_prefix("    EveryObject header;") then
                     -- ignore it                     
                  elseif line.has_prefix("} C_struct_") then
                     line.remove_prefix("} C_struct_")
                     line.remove_between(line.first_index_of(';'), line.upper)
--                     std_output.put_string("Class: ")
--                     std_output.put_string(line)
--                     std_output.put_new_line
                     class_def.put_name(line)
                     state := Looking
                  elseif line.has_prefix("    ObjRef ") then
                     line.remove_prefix("    ObjRef ")
                     line.remove_leading_spaces
                     line.remove_between(line.first_index_of(';'), line.upper)
--                     std_output.put_string("Ref: ")
--                     std_output.put_string(line)
                     feature_def := find_or_create_feature(obj_ref_class_def.reference, line)
                  elseif line.has_prefix("    uint8 ") then
                     line.remove_prefix("    uint8 ")
                     line.remove_leading_spaces
                     line.remove_between(line.first_index_of(';'), line.upper)
--                     std_output.put_string("Byte: ")
--                     std_output.put_string(line)
                     feature_def := find_or_create_feature(byte_class_def.reference, line)
                  elseif line.has_prefix("    char ") then
                     line.remove_prefix("    char ")
                     line.remove_leading_spaces
                     line.remove_between(line.first_index_of(';'), line.upper)
--                     std_output.put_string("Char: ")
--                     std_output.put_string(line)
                     feature_def := find_or_create_feature(char_class_def.reference, line)
                  elseif line.has_prefix("    TimeStamp ") then
                     line.remove_prefix("    TimeStamp ")
                     line.remove_leading_spaces
                     line.remove_between(line.first_index_of(';'), line.upper)
--                     std_output.put_string("TimeStamp: ")
--                     std_output.put_string(line)
                     feature_def := find_or_create_feature(time_stamp_class_def.reference, line)
                  else
                     std_error.put_string("Unrecognized line: ")
                     std_error.put_string(line)
                     std_error.put_new_line
                  end

                  if feature_def /= Void then
                     class_def.add_feature(feature_def)

--                     std_output.put_string(" - type: ")
--                     std_output.put_unsigned_in_hexadecimal(feature_def.type)
--                     std_output.put_string("  num: ")
--                     std_output.put_integer(feature_def.number)
--                     std_output.put_string(" name: ")
--                     std_output.put_string(feature_def.name)
--                     std_output.put_new_line
                  end
               end
            end

            in_file.read_line_in(line)
         end

         inspect
            state
         when Looking then
            -- sucessful
         when Comment then
            std_error.put_string("ERROR - unterminated comment%N")
         when Reading then
            std_error.put_string("ERROR - missing typdef%N")
         end

         in_file.disconnect

        -- Write classes

         std_output.put_string("Classes: ")
         std_output.put_integer(all_classes.count)
         std_output.put_new_line

         hex_format.set_width(8)
         hex_format.set_zero_fill

         csv_file.connect_to("class_definition.csv")

         if not csv_file.is_connected then
            std_error.put_string("unable to open: class_definition.csv%N")
            die_with_code(exit_failure_code)
         end

         from
            i := all_classes.lower
         variant
            all_classes.upper - i
         until
            i > all_classes.upper
         loop
            class_def := all_classes.item(i)

            std_output.put_string("Class: ")
            std_output.put_string(" 0x")
            std_output.put_unsigned_in_hexadecimal(class_def.reference)
            std_output.put_string(" ")
            std_output.put_string(class_def.name.name)
            std_output.put_string(" ref_list: 0x")
            std_output.put_unsigned_in_hexadecimal(class_def.reference_list.reference)

            csv_file.put_string("0x")
            csv_file.put_unsigned_in_hexadecimal_format(class_def.reference, hex_format.to_integer)
            csv_file.put_character(',')

            csv_file.put_string(current_time_stamp)
            csv_file.put_character(',')

            csv_file.put_string("0x")
            csv_file.put_unsigned_in_hexadecimal_format(class_def_class_def.reference, hex_format.to_integer)
            csv_file.put_character(',')

            csv_file.put_string("0x")
            csv_file.put_unsigned_in_hexadecimal_format(class_def.reference_list.reference, hex_format.to_integer)
            csv_file.put_character(',')

            csv_file.put_string("0x")
            csv_file.put_unsigned_in_hexadecimal_format(class_def.name.reference, hex_format.to_integer)

            from
               j := class_def.features.lower
            variant
               class_def.features.upper - j
            until
               j > class_def.features.upper
            loop
               std_output.put_string("   ")
               std_output.put_string(" 0x")
               std_output.put_unsigned_in_hexadecimal(class_def.features.item(j).reference)

               csv_file.put_character(',')
               csv_file.put_string("0x")
               csv_file.put_unsigned_in_hexadecimal_format(class_def.features.item(j).reference, hex_format.to_integer)

               j := j + 1
            end

            std_output.put_new_line

            csv_file.put_new_line

            i := i + 1
         end

         csv_file.disconnect


        -- Write features

         csv_file.connect_to("feature_definition.csv")

         if not csv_file.is_connected then
            std_error.put_string("unable to open: feature_definition.csv%N")
            die_with_code(exit_failure_code)
         end

         from
            i := all_features.lower
         variant
            all_features.upper - i
         until
            i > all_features.upper
         loop
            std_output.put_string("Feature: ")
            std_output.put_string(" 0x")
            std_output.put_unsigned_in_hexadecimal(all_features.item(i).reference)
            std_output.put_string(" ref_list: 0x")
            std_output.put_unsigned_in_hexadecimal(all_features.item(i).reference_list.reference)
            std_output.put_string(" type: 0x")
            std_output.put_unsigned_in_hexadecimal(all_features.item(i).type)
            std_output.put_string(" name: 0x")
            std_output.put_unsigned_in_hexadecimal(all_features.item(i).name.reference)
            std_output.put_string(" num: ")
            std_output.put_integer(all_features.item(i).number)
            std_output.put_string("  ")
            std_output.put_string(all_features.item(i).name.name)

            std_output.put_new_line

            csv_file.put_string("0x")
            csv_file.put_unsigned_in_hexadecimal_format(all_features.item(i).reference, hex_format.to_integer)
            csv_file.put_character(',')

            csv_file.put_string(current_time_stamp)
            csv_file.put_character(',')

            csv_file.put_string("0x")
            csv_file.put_unsigned_in_hexadecimal_format(feat_def_class_def.reference, hex_format.to_integer)
            csv_file.put_character(',')

            csv_file.put_string("0x")
            csv_file.put_unsigned_in_hexadecimal_format(all_features.item(i).reference_list.reference,
                                                        hex_format.to_integer)
            csv_file.put_character(',')

            csv_file.put_string("0x")
            csv_file.put_unsigned_in_hexadecimal_format(all_features.item(i).type, hex_format.to_integer)
            csv_file.put_character(',')

            csv_file.put_string("0x")
            csv_file.put_unsigned_in_hexadecimal_format(all_features.item(i).name.reference, hex_format.to_integer)
            csv_file.put_character(',')

            csv_file.put_integer(all_features.item(i).number)
            csv_file.put_new_line

            i := i + 1
         end

         csv_file.disconnect


        -- Write names

         csv_file.connect_to("name.csv")

         if not csv_file.is_connected then
            std_error.put_string("unable to open: name.csv%N")
            die_with_code(exit_failure_code)
         end

         from
            i := all_names.lower
         variant
            all_names.upper - i
         until
            i > all_names.upper
         loop
            name := all_names.item(i)

            std_output.put_string("Name: ")
            std_output.put_string(" 0x")
            std_output.put_unsigned_in_hexadecimal(name.reference)
            std_output.put_string(" ")
            std_output.put_string(name.name)
            std_output.put_string(" ref_list: 0x")
            std_output.put_unsigned_in_hexadecimal(name.reference_list.reference)

            csv_file.put_string("0x")
            csv_file.put_unsigned_in_hexadecimal_format(name.reference, hex_format.to_integer)
            csv_file.put_character(',')

            csv_file.put_string(current_time_stamp)
            csv_file.put_character(',')

            csv_file.put_string("0x")
            csv_file.put_unsigned_in_hexadecimal_format(name_class_def.reference, hex_format.to_integer)
            csv_file.put_character(',')

            csv_file.put_string("0x")
            csv_file.put_unsigned_in_hexadecimal_format(name.reference_list.reference, hex_format.to_integer)

            from
               j := name.spellings.lower
            variant
               name.spellings.upper - j
            until
               j > name.spellings.upper
            loop
               std_output.put_string(" 0x")
               std_output.put_unsigned_in_hexadecimal(name.spellings.item(j).reference)

               csv_file.put_character(',')
               csv_file.put_string("0x")
               csv_file.put_unsigned_in_hexadecimal_format(name.spellings.item(j).reference, hex_format.to_integer)

               j := j + 1
            end

            std_output.put_new_line

            csv_file.put_new_line

            i := i + 1
         end

         csv_file.disconnect



        -- Write spellings

         csv_file.connect_to("spelling.csv")

         if not csv_file.is_connected then
            std_error.put_string("unable to open: spelling.csv%N")
            die_with_code(exit_failure_code)
         end

         from
            i := all_spellings.lower
         variant
            all_spellings.upper - i
         until
            i > all_spellings.upper
         loop
            std_output.put_string("Spelling: ")
            std_output.put_string(" 0x")
            std_output.put_unsigned_in_hexadecimal(all_spellings.item(i).reference)
            std_output.put_string(" ref_list: 0x")
            std_output.put_unsigned_in_hexadecimal(all_spellings.item(i).reference_list.reference)
            std_output.put_string(" ")
            std_output.put_string(all_spellings.item(i).spelling)

            std_output.put_new_line

            csv_file.put_string("0x")
            csv_file.put_unsigned_in_hexadecimal_format(all_spellings.item(i).reference, hex_format.to_integer)
            csv_file.put_character(',')

            csv_file.put_string(current_time_stamp)
            csv_file.put_character(',')

            csv_file.put_string("0x")
            csv_file.put_unsigned_in_hexadecimal_format(spelling_class_def.reference, hex_format.to_integer)
            csv_file.put_character(',')

            csv_file.put_string("0x")
            csv_file.put_unsigned_in_hexadecimal_format(all_spellings.item(i).reference_list.reference,
                                                        hex_format.to_integer)
            csv_file.put_character(',')

            csv_file.put_character('"')
            csv_file.put_string(all_spellings.item(i).spelling)
            csv_file.put_character('"')

            csv_file.put_new_line

            i := i + 1
         end

         csv_file.disconnect


        -- Write reference lists

         csv_file.connect_to("reference_list.csv")

         if not csv_file.is_connected then
            std_error.put_string("unable to open: reference_list.csv%N")
            die_with_code(exit_failure_code)
         end

         from
            i := all_reference_lists.lower
         variant
            all_reference_lists.upper - i
         until
            i > all_reference_lists.upper
         loop
            ref_list := all_reference_lists.item(i)

            std_output.put_string("Reference_List: ")
            std_output.put_string(" 0x")
            std_output.put_unsigned_in_hexadecimal(ref_list.reference)

            csv_file.put_string("0x")
            csv_file.put_unsigned_in_hexadecimal_format(ref_list.reference, hex_format.to_integer)
            csv_file.put_character(',')

            csv_file.put_string(current_time_stamp)
            csv_file.put_character(',')

            csv_file.put_string("0x")
            csv_file.put_unsigned_in_hexadecimal_format(ref_list_class_def.reference, hex_format.to_integer)

            from
               j := ref_list.list.lower
            variant
               ref_list.list.upper - j
            until
               j > ref_list.list.upper
            loop
               std_output.put_string(" 0x")
               std_output.put_unsigned_in_hexadecimal(ref_list.list.item(j))

               csv_file.put_character(',')
               csv_file.put_string("0x")
               csv_file.put_unsigned_in_hexadecimal_format(ref_list.list.item(j), hex_format.to_integer)

               j := j + 1
            end

            std_output.put_new_line

            csv_file.put_new_line

            i := i + 1
         end

         csv_file.disconnect
      end

   find_or_create_feature(type_ref: UNSIGNED; name: STRING): FEATURE_DEFINITION is
      local
         i: INTEGER
         num_elem: INTEGER
         tmp_str: STRING
      do
         tmp_str := string_pool.item(name.count)

         tmp_str.copy(name)

         if tmp_str.last = ']' then  -- it's an array
            i := tmp_str.first_index_of('[')

            num_elem := tmp_str.item(i+1).code - ('0').code

            if tmp_str.item(i+2) /= ']' then  -- two digit number
               num_elem := num_elem * 10 + tmp_str.item(i+2).code - ('0').code
            end

            tmp_str.remove_between(i, tmp_str.count)
         else
            num_elem := 1
         end


         Result := find_feature(type_ref, tmp_str, num_elem)

         if Result = Void then
            !!Result.make(type_ref, tmp_str, num_elem)
         end

         string_pool.put(tmp_str)
      end


   time_stamp: NWOS_TIME_STAMP is
      once
         !!Result.make
      end

   time_stamp_string: STRING is
      once
         !!Result.make(36)
      end

   current_time_stamp: STRING is
      do
         Result := time_stamp_string

         time_stamp.now

         Result.clear
         Result.extend('"')
         time_stamp.append_in(Result)
         Result.extend('"')
      end


   in_file: STD_FILE_READ

   csv_file: STD_FILE_WRITE is
      once
         !!Result.make
      end

end

