/*
--          This file is part of the New World OS and Objectify projects
--                     Copyright (C) 2007, 2009  QRW Software
--               J. Scott Edwards - j.scott.edwards.nwos@gmail.com 
--
--   This program is free software: you can redistribute it and/or modify
--   it under the terms of the GNU General Public License as published by
--   the Free Software Foundation, either version 3 of the License, or
--   (at your option) any later version.
--
--   This program is distributed in the hope that it will be useful,
--   but WITHOUT ANY WARRANTY; without even the implied warranty of
--   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
--   GNU General Public License for more details.
--
--   You should have received a copy of the GNU General Public License
--   along with this program, in the file LICENSE.  If not, see 
--   <http://www.gnu.org/licenses/>.
--
--   For the latest information, source code (SVN), releases, and bug tracking
--   go to:
--      http://savannah.nongnu.org/projects/objectify
--
--   For releases from Alpha_30 and up, bug and feature request tracking go to:
--      http://sourceforge.net/projects/objectify
--
--   For older bug tracking, releases and source code (CVS) prior to the
--   Alpha_30 release go to:
--      http://sourceforge.net/projects/nwos
--
--   Other related websites:
--      http://www.qrwsoftware.com
--      http://www.worldwide-database.org
--
--   You can also contact me via paper mail at:
--
--      QRW Software
--      P.O. Box 27511
--      Salt Lake City, UT 84127-0511, USA.
--
--   $Author: jsedwards $
--   $Date: 2009-10-06 08:06:23 -0600 (Tue, 06 Oct 2009) $
--   $Revision: 4384 $
--
--   NOTE: Subversion does not support the Log keyword so I have removed the
--   logs that were here when I was using CVS.  Use the "svn log" command to
--   see the revision history of this file.  I have retained the CVS log from
--   this file before it was moved to the attic.
--   (See http://subversion.tigris.org/faq.html#log-in-source)
--
--
-- Revision 1.1  2007/02/24 18:40:11  jsedwards
-- One time use program to move 0017 archive root objects to correct block for
-- a 0018 archive.
--
*/

/**********************************************************************************/
/*  This is a kludged program to move any root objects (entry points) in a 0017   */
/*  archive into the correct block for a 0018 archive.  This is necessary because */
/*  the hash of the root reference to block number changed from:                  */
/*                                                                                */
/*    (ref % total_private_blocks) + total_public_blocks                          */
/*                                                                                */
/*  to                                                                            */
/*                                                                                */
/*    ((ref - total_public_blocks) % total_private_blocks) + total_public_blocks  */
/*                                                                                */
/*  NOTE: you have to hack the objectify.c file to build this because several of  */
/*        the functions needed by this program are not normally global.   On all  */
/*        the variables and functions declared "extern" below you must make a     */
/*        special version of objectify.c and use it when linking.                 */
/**********************************************************************************/

#include <stdio.h>
#include <string.h>
#include "objectify_private.h"

extern uint32 total_public_blocks;
extern uint32 total_private_blocks;
extern uint32 hash_ref(ObjRef* ref);
extern uint32 hash_uint32_ref(uint32 ref);
extern void set_bit_in_map(uint32 block);


int main(int argc, char* argv[])
{
    ObjRef root_obj_ref;
    ObjRef old_root_ref;
    uint8 big_key[16 + 8 + 4];
    uint8 bf_key[16];
    uint32 linear;
    uint32 serial;
    uint32 old_root;
    uint32 new_root;
    char msg[128];
    C_struct_Root root_obj;

    printf("\n");

    nwos_log_arguments(argc, argv);

    nwos_get_key_from_password(big_key, sizeof(big_key));

    memcpy(bf_key, big_key, 16);
    linear = ((uint32)big_key[16] << 24) | ((uint32)big_key[17] << 16) | ((uint32)big_key[18] << 8) | (uint32)big_key[19];
    memcpy(root_obj_ref.id, big_key+20, 4);
    serial = ((uint32)big_key[24] << 24) | ((uint32)big_key[25] << 16) | ((uint32)big_key[26] << 8) | (uint32)big_key[27];

    nwos_initialize_objectify(bf_key, linear, serial, DEFAULT_TYPE_RW, DEFAULT_FILE);

    printf("root: %02x%02x%02x%02x\n", root_obj_ref.id[0], root_obj_ref.id[1], root_obj_ref.id[2], root_obj_ref.id[3]);

    old_root = (nwos_ref_to_word(&root_obj_ref) % total_private_blocks) + total_public_blocks;
    snprintf(msg, sizeof(msg), "Old hash: %08x", old_root);
    nwos_log(msg);
    printf("%s\n", msg);

    new_root = hash_ref(&root_obj_ref);

    snprintf(msg, sizeof(msg), "New hash: %08x", new_root);
    nwos_log(msg);
    printf("%s\n", msg);

    nwos_word_to_ref(old_root, &old_root_ref);

    snprintf(msg, sizeof(msg), "Old ref: %02x%02x%02x%02x  block: %08x", 
	     old_root_ref.id[0], old_root_ref.id[1], old_root_ref.id[2], old_root_ref.id[3],
	     hash_ref(&old_root_ref));
    nwos_log(msg);
    printf("%s\n", msg);

    assert(hash_ref(&old_root_ref) == old_root);

    nwos_read_object_from_disk(&old_root_ref, &root_obj, sizeof(root_obj));

    snprintf(msg, sizeof(msg),
	     "class_definition_class: %02x%02x%02x%02x  reference_list_class: %02x%02x%02x%02x\n",
	     root_obj.class_definition_class.id[0],
	     root_obj.class_definition_class.id[1],
	     root_obj.class_definition_class.id[2],
	     root_obj.class_definition_class.id[3],
	     root_obj.reference_list_class.id[0],
	     root_obj.reference_list_class.id[1],
	     root_obj.reference_list_class.id[2],
	     root_obj.reference_list_class.id[3]);
    nwos_log(msg);
    printf("%s\n", msg);

    copy_reference(&root_obj.header.common.id, &root_obj_ref);
    set_bit_in_map(hash_ref(&root_obj_ref));
    nwos_write_object_to_disk(&root_obj_ref, &root_obj, sizeof(root_obj));

    nwos_remove_object(&old_root_ref);

    nwos_terminate_objectify();

    return 0;
}

