/*
--          This file is part of the New World OS and Objectify projects
--            Copyright (C) 2004, 2005, 2006, 2007, 2009  QRW Software
--               J. Scott Edwards - j.scott.edwards.nwos@gmail.com 
--
--   This program is free software: you can redistribute it and/or modify
--   it under the terms of the GNU General Public License as published by
--   the Free Software Foundation, either version 3 of the License, or
--   (at your option) any later version.
--
--   This program is distributed in the hope that it will be useful,
--   but WITHOUT ANY WARRANTY; without even the implied warranty of
--   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
--   GNU General Public License for more details.
--
--   You should have received a copy of the GNU General Public License
--   along with this program, in the file LICENSE.  If not, see 
--   <http://www.gnu.org/licenses/>.
--
--   For the latest information, source code (SVN), releases, and bug tracking
--   go to:
--      http://savannah.nongnu.org/projects/objectify
--
--   For releases from Alpha_30 and up, bug and feature request tracking go to:
--      http://sourceforge.net/projects/objectify
--
--   For older bug tracking, releases and source code (CVS) prior to the
--   Alpha_30 release go to:
--      http://sourceforge.net/projects/nwos
--
--   Other related websites:
--      http://www.qrwsoftware.com
--      http://www.worldwide-database.org
--
--   You can also contact me via paper mail at:
--
--      QRW Software
--      P.O. Box 27511
--      Salt Lake City, UT 84127-0511, USA.
--
--   $Author: jsedwards $
--   $Date: 2009-10-06 08:06:23 -0600 (Tue, 06 Oct 2009) $
--   $Revision: 4384 $
--
--   NOTE: Subversion does not support the Log keyword so I have removed the
--   logs that were here when I was using CVS.  Use the "svn log" command to
--   see the revision history of this file.
--   (See http://subversion.tigris.org/faq.html#log-in-source)
--
*/

/* This file was generated by the convert_csv_to_c_structs.e program from the  */
/* class_definition.csv, feature_definition.csv, name.csv, and spelling.csv    */
/* files.  You should not make changes to this file.  Any changes should be    */
/* made to the .cvs files and then rerun the convert_csv_to_c_structs program. */


typedef struct {
    EveryObject header;
    ObjRef name;
    uint8 count;
    ObjRef feature[0];
} C_struct_Class_Definition;

typedef struct {
    EveryObject header;
    ObjRef character_set;
    uint8 count;
    char storage[0];
} C_struct_Spelling;

typedef struct {
    EveryObject header;
    uint8 count;
    ObjRef spelling[0];
} C_struct_Name;

typedef struct {
    EveryObject header;
    ObjRef inherit;
    ObjRef class;
    ObjRef label;
    uint8 count;
} C_struct_Feature_Definition;

typedef struct {
    EveryObject header;
    uint8 md5sum[16];
} C_struct_MD5sum;

typedef struct {
    EveryObject header;
    ObjRef class_definition_class;
    ObjRef reference_list_class;
} C_struct_Root;

typedef struct {
    EveryObject header;
    ObjRef thing;
    ObjRef language;
    ObjRef spelling;
} C_struct_Word;

typedef struct {
    EveryObject header;
    ObjRef full_word;
    ObjRef language;
    ObjRef spelling;
} C_struct_Abbreviation;

typedef struct {
    EveryObject header;
    ObjRef definition;
} C_struct_Language;

typedef struct {
    EveryObject header;
    ObjRef contact;
    uint8 count;
    char storage[0];
} C_struct_Email_Address;

typedef struct {
    EveryObject header;
    ObjRef name;
    ObjRef date;
    ObjRef capital;
    ObjRef postal_code;
    uint8 number;
} C_struct_US_State;

typedef struct {
    EveryObject header;
    ObjRef name;
    ObjRef state;
    ObjRef country;
} C_struct_US_City;

typedef struct {
    EveryObject header;
    ObjRef state;
    ObjRef area;
    char storage[3];
} C_struct_Area_Code;

typedef struct {
    EveryObject header;
    ObjRef country;
    ObjRef area_code;
    char storage[7];
} C_struct_Phone_Number;

typedef struct {
    EveryObject header;
    ObjRef residence;
    ObjRef number;
} C_struct_Home_Phone;

typedef struct {
    EveryObject header;
    ObjRef person;
    ObjRef number;
} C_struct_Mobile_Phone;

typedef struct {
    EveryObject header;
    ObjRef business;
    ObjRef person;
    ObjRef number;
    ObjRef extension;
} C_struct_Work_Phone;

typedef struct {
    EveryObject header;
    uint8 count;
    char storage[0];
} C_struct_Year;

typedef struct {
    EveryObject header;
    ObjRef definition;
    char storage[2];
    uint8 minimum_days;
    uint8 maximum_days;
} C_struct_Month;

typedef struct {
    EveryObject header;
    ObjRef year;
    ObjRef month;
    uint8 day_of_month;
} C_struct_Date;

typedef struct {
    EveryObject header;
    ObjRef definition;
} C_struct_Gender;

typedef struct {
    EveryObject header;
    ObjRef gender;
    ObjRef title;
    ObjRef first_name;
    ObjRef middle_name;
    ObjRef last_name;
    ObjRef maiden_name;
    ObjRef preferred_name;
    ObjRef goes_by;
    ObjRef nickname;
    ObjRef birth_date;
    ObjRef birth_place;
    ObjRef death_date;
    ObjRef death_place;
    ObjRef height;
    ObjRef mailing_address;
} C_struct_Person;

typedef struct {
    EveryObject header;
    ObjRef person;
    char storage[9];
} C_struct_Social_Security_Number;

typedef struct {
    EveryObject header;
    ObjRef person;
    ObjRef residence;
    ObjRef from_date;
    ObjRef until_date;
} C_struct_Residence;

typedef struct {
    EveryObject header;
    ObjRef address;
} C_struct_House;

typedef struct {
    EveryObject header;
    ObjRef definition;
} C_struct_Direction;

typedef struct {
    EveryObject header;
    ObjRef number;
    ObjRef street;
    ObjRef zip_code;
} C_struct_US_Address;

typedef struct {
    EveryObject header;
    ObjRef city;
    char zip[5];
    char plus[4];
} C_struct_Zip_Code;

typedef struct {
    EveryObject header;
    ObjRef direction;
    uint8 count;
    char storage[0];
} C_struct_Street_Number;

typedef struct {
    EveryObject header;
    ObjRef name;
    ObjRef suffix;
    ObjRef city;
    ObjRef coordinate;
    ObjRef cross_street_start;
    ObjRef cross_street_end;
    ObjRef note;
} C_struct_Street;

typedef struct {
    EveryObject header;
    ObjRef user;
    ObjRef host;
    uint8 username_count;
    char username[0];
    uint8 password_count;
    char password[0];
} C_struct_Password;

typedef struct {
    EveryObject header;
    ObjRef account;
    ObjRef to;
    ObjRef amount;
    ObjRef date_written;
    ObjRef date_mailed;
    ObjRef date_cleared;
    ObjRef memo;
    ObjRef status;
} C_struct_Check;

typedef struct {
    EveryObject header;
    uint8 size[4];
    TimeStamp modification_time;
    ObjRef md5sum;
    ObjRef sha1sum;
    ObjRef media;
    ObjRef block_list;
} C_struct_File;

typedef struct {
    EveryObject header;
    ObjRef file;
    uint8 count;
    char storage[0];
} C_struct_File_Path;

typedef struct {
    EveryObject header;
    char id[12];
    ObjRef name;
    ObjRef note;
    uint8 count[4];
    ObjRef files[0];
} C_struct_Disc_List;

typedef struct {
    EveryObject header;
    ObjRef disc_list;
    ObjRef configuration;
    ObjRef date;
    ObjRef media;
    ObjRef location;
    uint8 copy_number;
} C_struct_Disc_Copy;

typedef struct {
    EveryObject header;
    ObjRef name;
} C_struct_Storage_Location;


