/* MD5.H - header file for MD5C.C
 * $FreeBSD$
 */

/* Copyright (C) 1991-2, RSA Data Security, Inc. Created 1991. All
rights reserved.

License to copy and use this software is granted provided that it
is identified as the "RSA Data Security, Inc. MD5 Message-Digest
Algorithm" in all material mentioning or referencing this software
or this function.

License is also granted to make and use derivative works provided
that such works are identified as "derived from the RSA Data
Security, Inc. MD5 Message-Digest Algorithm" in all material
mentioning or referencing the derived work.

RSA Data Security, Inc. makes no representations concerning either
the merchantability of this software or the suitability of this
software for any particular purpose. It is provided "as is"
without express or implied warranty of any kind.

These notices must be retained in any copies of any part of this
documentation and/or software.

 */

/*
--          This file is part of the New World OS and Objectify projects
--               J. Scott Edwards - j.scott.edwards.nwos@gmail.com 
--
--   For the latest information, source code (SVN), releases, and bug tracking
--   go to:
--      http://savannah.nongnu.org/projects/objectify
--
--   For releases from Alpha_30 and up, bug and feature request tracking go to:
--      http://sourceforge.net/projects/objectify
--
--   For older bug tracking, releases and source code (CVS) prior to the
--   Alpha_30 release go to:
--      http://sourceforge.net/projects/nwos
--
--   You can also contact me via paper mail at:
--
--      QRW Software
--      P.O. Box 27511
--      Salt Lake City, UT 84127-0511, USA.
--
--   $Author: jsedwards $
--   $Date: 2009-10-06 08:06:23 -0600 (Tue, 06 Oct 2009) $
--   $Revision: 4384 $
--
--   NOTE: Subversion does not support the Log keyword so I have removed the
--   logs that were here when I was using CVS.  Use the "svn log" command to
--   see the revision history of this file.  Since this file was copied from
--   the file originally in the root directory I have retained the CVS log
--   messages from that file.
--   (See http://subversion.tigris.org/faq.html#log-in-source)
--
--
--  Revision 1.3  2006/10/27 02:47:37  jsedwards
--  Changed "unsigned long" variables to "unsigned int" because on 64 bit
--  machines "unsigned long" is 64 bits and that breaks this function.
--
--  Revision 1.2  2006/10/26 01:51:30  jsedwards
--  Merged alpha_05_branch back into main trunk.
--
--  Revision 1.1.2.1  2006/08/24 12:09:39  jsedwards
--  Copied from "lab" repository (from "nwos" project on SourceForge).
--
--  Revision 1.1  2004/10/30 20:30:49  jsedwards
--  Taken from 'libmd' directory in package "gskey-2.0.tar.gz" downloaded
--  from "http://unipro.com.pl/download/".
--
*/


#ifndef _MD5_H_
#define _MD5_H_
/* MD5 context. */
typedef struct {
  unsigned int state[4];	/* state (ABCD) */
  unsigned int count[2];	/* number of bits, modulo 2^64 (lsb first) */
  unsigned char buffer[64];	/* input buffer */
} MD5_CTX;

void   MD5Init (MD5_CTX *);
void   MD5Update (MD5_CTX *, const unsigned char *, unsigned int);
void   MD5Final (unsigned char [16], MD5_CTX *);
char * MD5End(MD5_CTX *);
char * MD5File(char *);
char * MD5Data(const unsigned char *, unsigned int);
#endif /* _MD5_H_ */
