--
--             This file is part of the New World OS project
--                    Copyright (C) 2008  QRW Software
--           J. Scott Edwards - j.scott.edwards.nwos@gmail.com 
--                      http://www.qrwsoftware.com
--                      http://nwos.sourceforge.com
--
--   This program is free software: you can redistribute it and/or modify
--   it under the terms of the GNU General Public License as published by
--   the Free Software Foundation, either version 3 of the License, or
--   (at your option) any later version.
--
--   This program is distributed in the hope that it will be useful,
--   but WITHOUT ANY WARRANTY; without even the implied warranty of
--   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
--   GNU General Public License for more details.
--
--   You should have received a copy of the GNU General Public License
--   along with this program, in the file LICENSE.  If not, see 
--   <http://www.gnu.org/licenses/>.
--
--   You can also contact me via paper mail at:
--
--      QRW Software
--      P.O. Box 27511
--      Salt Lake City, UT 84127-0511, USA.
--
--
-- $Log: path_and_file_association.e,v $
-- Revision 1.1  2008/11/28 17:11:56  jsedwards
-- Initial experimental quick hack.
--
--


class PATH_AND_FILE_ASSOCIATION

inherit OBJECTIFY_OBJECT

creation read_from_disk

feature

   read_from_disk(id: REFERENCE) is
      do
         !!reference.copy(id)
         storage := wrapper_read_path_and_file_association(reference.to_external)

--             std_output.put_string("Ref list count: ");
--             std_output.put_integer(references.count);
--             std_output.put_new_line;
      end

   path: REFERENCE is
      do
         !!Result.make
         wrapper_path_and_file_association_path(storage, Result.to_external)
      end

   file: REFERENCE is
      do
         !!Result.make
         wrapper_path_and_file_association_file(storage, Result.to_external)
      end


feature {NONE}

   wrapper_read_path_and_file_association(ref: POINTER): POINTER is
      external "C"
      end

   wrapper_path_and_file_association_path(obj: POINTER; ref: POINTER) is
      external "C"
      end

   wrapper_path_and_file_association_file(obj: POINTER; ref: POINTER) is
      external "C"
      end

end

