/*
--         This file is part of the New World OS and Objectify projects
--                    Copyright (C) 2007-2009  QRW Software
--              J. Scott Edwards - j.scott.edwards.nwos@gmail.com 
--                         http://www.qrwsoftware.com
--                         http://nwos.sourceforge.com
--                      http://objectify.sourceforge.com
--
--   This program is free software: you can redistribute it and/or modify
--   it under the terms of the GNU General Public License as published by
--   the Free Software Foundation, either version 3 of the License, or
--   (at your option) any later version.
--
--   This program is distributed in the hope that it will be useful,
--   but WITHOUT ANY WARRANTY; without even the implied warranty of
--   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
--   GNU General Public License for more details.
--
--   You should have received a copy of the GNU General Public License
--   along with this program, in the file LICENSE.  If not, see 
--   <http://www.gnu.org/licenses/>.
--
--   You can also contact me via paper mail at:
--
--      QRW Software
--      P.O. Box 27511
--      Salt Lake City, UT 84127-0511, USA.
--
--
-- $Log: reference.c,v $
-- Revision 1.1  2009/04/11 19:57:30  jsedwards
-- Created with functions removed from the disk_io.c file.
--
--
*/

#include "reference.h"


/**********************/
/* Reference testing. */
/**********************/

bool nwos_is_public_reference(ObjRef* ref)
{
    return nwos_ref_to_word(ref) <= MAXIMUM_PUBLIC_REFERENCE;
}


bool nwos_is_private_reference(ObjRef* ref)
{
    return MINIMUM_PRIVATE_REFERENCE <= nwos_ref_to_word(ref) && nwos_ref_to_word(ref) <= MAXIMUM_PRIVATE_REFERENCE;
}


bool nwos_is_temporary_reference(ObjRef* ref)
{
    return MINIMUM_TEMPORARY_REFERENCE <= nwos_ref_to_word(ref) && nwos_ref_to_word(ref) <= MAXIMUM_TEMPORARY_REFERENCE;
}


Reference_Type nwos_reference_type(ObjRef* ref)
{
    if (nwos_is_public_reference(ref))
    {
	return Public_Reference;
    }

    if (nwos_is_private_reference(ref))
    {
	return Private_Reference;
    }

    if (nwos_is_temporary_reference(ref))
    {
	return Temporary_Reference;
    }

    return Unknown_Reference;     /* this should never happen */
}


