#
#          This file is part of the New World OS and Objectify projects
#                     Copyright (C) 2009, 2010  QRW Software
#               J. Scott Edwards - j.scott.edwards.nwos@gmail.com 
#
#   This program is free software: you can redistribute it and/or modify
#   it under the terms of the GNU General Public License as published by
#   the Free Software Foundation, either version 3 of the License, or
#   (at your option) any later version.
#
#   This program is distributed in the hope that it will be useful,
#   but WITHOUT ANY WARRANTY; without even the implied warranty of
#   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#   GNU General Public License for more details.
#
#   You should have received a copy of the GNU General Public License
#   along with this program, in the file LICENSE.  If not, see 
#   <http://www.gnu.org/licenses/>.
#
#   For the latest information, source code (SVN), releases, and bug tracking
#   go to:
#      http://savannah.nongnu.org/projects/objectify
#
#   For releases from Alpha_30 and up, bug and feature request tracking go to:
#      http://sourceforge.net/projects/objectify
#
#   For older bug tracking, releases and source code (CVS) prior to the
#   Alpha_30 release go to:
#      http://sourceforge.net/projects/nwos
#
#   Other related websites:
#      http://www.qrwsoftware.com
#      http://www.worldwide-database.org
#
#   You can also contact me via paper mail at:
#
#      QRW Software
#      P.O. Box 27511
#      Salt Lake City, UT 84127-0511, USA.
#
#   $Author: jsedwards $
#   $Date: 2010-09-19 16:28:43 -0600 (Sun, 19 Sep 2010) $
#   $Revision: 4761 $
#
#   NOTE: Subversion does not support the Log keyword so I have removed the
#   logs that were here when I was using CVS.  Use the "svn log" command to
#   see the revision history of this file.
#   (See http://subversion.tigris.org/faq.html#log-in-source)
# 


export OBJECTIFY_TEST_ONLY_DO_NOT_USE="Diff Compressed Test"
export OBJECTIFY_PRIVATE_PATH=/tmp/objectify_test/private.obj
export OBJECTIFY_LOG_FILE_PATH=/tmp/objectify_test/objectify_log
export OBJECTIFY_BACKUP_PATH=/tmp/objectify_test

EXEC=$PWD

if ! rm -fr /tmp/objectify_test; then
   echo ""
   echo "could not remove /tmp/objectify_test directory"
   echo ""
   exit 1
fi

if ! rm -fr /tmp/test; then
   echo ""
   echo "could not remove /tmp/objectify_test directory"
   echo ""
   exit 1
fi


mkdir /tmp/test
cd /tmp/test

echo "----------------------"
echo " creating test files"
echo "----------------------"

#dd if=/dev/random of=x7 bs=7 count=1

echo "WARNING: NOT using random data!!!!!"
echo -n "1234567" > x7

cat          x7          x7 >        x14
cat         x14         x14 >        x28
cat         x28         x28 >        x56
cat         x56         x56 >       x112
cat        x112        x112 >       x224
cat        x224        x224 >       x448
cat        x448        x448 >       x896
cat        x896        x896 >      x1792
cat       x1792       x1792 >      x3584
cat       x3584       x3584 >      x7168
cat       x7168       x7168 >     x14336
cat      x14336      x14336 >     x28672
cat      x28672      x28672 >     x57344
cat      x57344      x57344 >    x114688
cat     x114688     x114688 >    x229376
cat     x229376     x229376 >    x458752
cat     x458752     x458752 >    x917504
cat     x917504     x917504 >   x1835008
cat    x1835008    x1835008 >   x3670016
cat    x3670016    x3670016 >   x7340032
cat    x7340032    x7340032 >  x14680064
cat   x14680064   x14680064 >  x29360128


echo "---------------"
echo " prep disk..."
echo "---------------"
if ! $EXEC/src/apps/util/archive-prep; then
   echo ""
   echo "archive-prep failed"
   echo ""
   exit 1
fi

mkdir /tmp/objectify_test/save
mv -i /tmp/objectify_test/*.dif  /tmp/objectify_test/save

sleep 2

echo "---------------------"
echo " compress before..."
echo "---------------------"
if ! $EXEC/src/apps/util/archive-compress /tmp/objectify_test/compressed-before; then
   echo ""
   echo "archive-compress failed"
   echo ""
   exit 1
fi

sleep 2

echo "---------------"
echo " file-imports..."
echo "---------------"
if ! $EXEC/src/apps/file/file-import x1*; then
   echo ""
   echo "file-import failed"
   echo ""
   exit 1
fi

sleep 1

if ! $EXEC/src/apps/file/file-import x2*; then
   echo ""
   echo "file-import failed"
   echo ""
   exit 1
fi

sleep 1

if ! $EXEC/src/apps/file/file-import x3*; then
   echo ""
   echo "file-import failed"
   echo ""
   exit 1
fi

sleep 1

if ! $EXEC/src/apps/file/file-import x4*; then
   echo ""
   echo "file-import failed"
   echo ""
   exit 1
fi

sleep 1

if ! $EXEC/src/apps/file/file-import x5*; then
   echo ""
   echo "file-import failed"
   echo ""
   exit 1
fi

sleep 1

if ! $EXEC/src/apps/file/file-import x7*; then
   echo ""
   echo "file-import failed"
   echo ""
   exit 1
fi

sleep 1

if ! $EXEC/src/apps/file/file-import x8*; then
   echo ""
   echo "file-import failed"
   echo ""
   exit 1
fi

sleep 1

if ! $EXEC/src/apps/file/file-import x9*; then
   echo ""
   echo "file-import failed"
   echo ""
   exit 1
fi

sleep 2


echo "---------------------"
echo " compress after..."
echo "---------------------"
if ! $EXEC/src/apps/util/archive-compress /tmp/objectify_test/compressed-after; then
   echo ""
   echo "archive-compress failed"
   echo ""
   exit 1
fi

sleep 2


echo "---------------------"
echo " diff compressed..."
echo "---------------------"
if ! $EXEC/src/apps/util/compressed-diff /tmp/objectify_test/compressed-before /tmp/objectify_test/compressed-after /tmp/objectify_test/diff-before-after > /tmp/objectify_test/diff-before-after.txt; then
   echo ""
   echo "compressed-diff failed"
   echo ""
   exit 1
fi

sleep 2


echo "---------------------"
echo " combine backups..."
echo "---------------------"
if ! $EXEC/src/apps/util/diff-combine /tmp/objectify_test/*.dif /tmp/objectify_test/combined-before-after; then
   echo ""
   echo "diff-combine failed"
   echo ""
   exit 1
fi

sleep 2


echo "-------------------------------------------"
echo " verify diff and combined are the same..."
echo "-------------------------------------------"
if ! diff -s /tmp/objectify_test/diff-before-after /tmp/objectify_test/combined-before-after; then
   echo ""
   echo "combined and diff files differ"
   echo ""
   exit 1
fi

sleep 2


echo "---------------------"
echo " patch compressed..."
echo "---------------------"
if ! $EXEC/src/apps/util/compressed-patch /tmp/objectify_test/compressed-before /tmp/objectify_test/combined-before-after /tmp/objectify_test/patched-after > /tmp/objectify_test/patched-after.txt; then
   echo ""
   echo "compressed-patch failed"
   echo ""
   exit 1
fi

sleep 2



echo "-------------------------------------------"
echo " verify diff and combined are the same..."
echo "-------------------------------------------"
if ! diff -s /tmp/objectify_test/compressed-after /tmp/objectify_test/patched-after; then
   echo ""
   echo "compressed and patched files differ"
   echo ""
   exit 1
fi

sleep 2



echo "--------------------------"
echo " prep disk for restore..."
echo "--------------------------"
if ! $EXEC/src/apps/util/archive-prep --no-private; then
   echo ""
   echo "archive-prep --no-private failed"
   echo ""
   exit 1
fi

sleep 1

echo "---------------------"
echo " expand..."
echo "---------------------"
if ! $EXEC/src/apps/util/archive-restore /tmp/objectify_test/patched-after; then
   echo ""
   echo "archive-restore failed"
   echo ""
   exit 1
fi

sleep 1

echo "---------------------"
echo " verify and remove..."
echo "---------------------"
if ! $EXEC/src/apps/file/file-verify --remove-no-shred *; then
   echo ""
   echo "file-verify --remove-no-shred failed"
   echo ""
   exit 1
fi

sleep 1

echo "-------------------------------"
echo " verify the files are gone..."
echo "-------------------------------"
if  ls x*; then
   echo ""
   echo "files were not removed!"
   echo ""
   exit 1
fi

sleep 1



echo "---------------------------"
echo " prep a second archive..."
echo "---------------------------"

if ! $EXEC/src/apps/util/archive-prep --no-private /tmp/objectify_test/private2.obj; then
   echo ""
   echo "archive-prep failed"
   echo ""
   exit 1
fi

sleep 2


echo "---------------------"
echo " sync archive..."
echo "---------------------"
if ! $EXEC/src/apps/util/archive-sync /tmp/objectify_test/private2.obj; then
   echo ""
   echo "archive-sync failed"
   echo ""
   exit 1
fi

sleep 2


echo "------------------------------"
echo " compress second archive..."
echo "------------------------------"

export OBJECTIFY_PRIVATE_PATH=/tmp/objectify_test/private2.obj

if ! $EXEC/src/apps/util/archive-compress /tmp/objectify_test/compressed-second; then
   echo ""
   echo "archive-compress failed"
   echo ""
   exit 1
fi


sleep 2

echo "-----------------------------------------------------"
echo " verify first and second compressed are the same..."
echo "-----------------------------------------------------"
if ! $EXEC/src/apps/util/compressed-diff /tmp/objectify_test/compressed-after /tmp/objectify_test/compressed-second | tee /tmp/diff_test.txt; then
   echo ""
   echo "first and second compressed files differ"
   echo ""
   exit 1
fi

if ! grep -q "Added: 0" /tmp/diff_test.txt; then
   echo ""
   echo "did not Added: 0"
   echo ""
   exit 1
fi

if ! grep -q "Changed: 0" /tmp/diff_test.txt; then
   echo ""
   echo "did not report Changed: 0"
   echo ""
   exit 1
fi


sleep 5

echo ""

echo "---------------------------"
echo " prep a third archive..."
echo "---------------------------"

if ! $EXEC/src/apps/util/archive-prep --no-private /tmp/objectify_test/private3.obj; then
   echo ""
   echo "archive-prep failed"
   echo ""
   exit 1
fi

sleep 2


echo "---------------------"
echo " sync archive..."
echo "---------------------"
if ! $EXEC/src/apps/util/archive-sync /tmp/objectify_test/private2.obj /tmp/objectify_test/private3.obj; then
   echo ""
   echo "archive-sync failed"
   echo ""
   exit 1
fi

sleep 2


echo "------------------------------"
echo " compress third archive..."
echo "------------------------------"

export OBJECTIFY_PRIVATE_PATH=/tmp/objectify_test/private3.obj

if ! $EXEC/src/apps/util/archive-compress /tmp/objectify_test/compressed-third; then
   echo ""
   echo "archive-compress failed"
   echo ""
   exit 1
fi


sleep 2

echo "-----------------------------------------------------"
echo " verify first and third compressed are the same..."
echo "-----------------------------------------------------"
if ! $EXEC/src/apps/util/compressed-diff /tmp/objectify_test/compressed-after /tmp/objectify_test/compressed-third | tee /tmp/diff_test.txt; then
   echo ""
   echo "first and third compressed files differ"
   echo ""
   exit 1
fi

if ! grep -q "Added: 0" /tmp/diff_test.txt; then
   echo ""
   echo "did not Added: 0"
   echo ""
   exit 1
fi

if ! grep -q "Changed: 0" /tmp/diff_test.txt; then
   echo ""
   echo "did not report Changed: 0"
   echo ""
   exit 1
fi

sleep 5

echo ""


echo "---------------------------"
echo " prep a fourth archive..."
echo "---------------------------"

if ! $EXEC/src/apps/util/archive-prep /tmp/objectify_test/private4.obj; then
   echo ""
   echo "archive-prep failed"
   echo ""
   exit 1
fi

sleep 2


echo "-----------------------------------"
echo " expand into non-empty archive..."
echo "-----------------------------------"

export OBJECTIFY_PRIVATE_PATH=/tmp/objectify_test/private4.obj

if $EXEC/src/apps/util/archive-restore /tmp/objectify_test/patched-after; then
   echo ""
   echo "archive-restore into non-empty archive succeeded"
   echo ""
   exit 1
fi

sleep 2


echo "------------------------------------------"
echo " sync archive into non-empty archive..."
echo "------------------------------------------"
if $EXEC/src/apps/util/archive-sync /tmp/objectify_test/private3.obj /tmp/objectify_test/private4.obj; then
   echo ""
   echo "archive-sync into non-empty archive succeeded"
   echo ""
   exit 1
fi

sleep 2


echo "------------------------------------------"
echo " sync archive with duplicate path..."
echo "------------------------------------------"
if $EXEC/src/apps/util/archive-sync /tmp/objectify_test/private4.obj; then
   echo ""
   echo "archive-sync with duplicate path succeeded"
   echo ""
   exit 1
fi

sleep 2

echo "------------------------------------------"
echo " sync archive with duplicate paths..."
echo "------------------------------------------"
if $EXEC/src/apps/util/archive-sync /tmp/objectify_test/private3.obj /tmp/objectify_test/private3.obj; then
   echo ""
   echo "archive-sync with duplicate paths succeeded"
   echo ""
   exit 1
fi


sleep 2

echo "--------------------------------------------------"
echo " sync with second archive when it is the same..."
echo "--------------------------------------------------"
if ! $EXEC/src/apps/util/archive-sync /tmp/objectify_test/private.obj /tmp/objectify_test/private2.obj; then
   echo ""
   echo "archive-sync failed"
   echo ""
   exit 1
fi

sleep 2


echo "------------------------------------------"
echo " export files from third archive..."
echo "------------------------------------------"

export OBJECTIFY_PRIVATE_PATH=/tmp/objectify_test/private3.obj

if ! $EXEC/src/apps/file/file-export "*"; then
   echo ""
   echo "file-export failed"
   echo ""
   exit 1
fi

sleep 2



echo "-----------------------------------------------"
echo " add another password to original archive..."
echo "-----------------------------------------------"
export OBJECTIFY_PRIVATE_PATH=/tmp/objectify_test/private.obj
export OBJECTIFY_TEST_ONLY_DO_NOT_USE="Diff Compressed Test Too"

if ! $EXEC/src/apps/util/zone-add; then
   echo ""
   echo "zone-add failed"
   echo ""
   exit 1
fi

sleep 2

echo "-------------------"
echo " file-imports..."
echo "-------------------"
if ! $EXEC/src/apps/file/file-import x1*; then
   echo ""
   echo "file-import failed"
   echo ""
   exit 1
fi

sleep 1

if ! $EXEC/src/apps/file/file-import x2*; then
   echo ""
   echo "file-import failed"
   echo ""
   exit 1
fi

sleep 1

if ! $EXEC/src/apps/file/file-import x3*; then
   echo ""
   echo "file-import failed"
   echo ""
   exit 1
fi

sleep 1

if ! $EXEC/src/apps/file/file-import x4*; then
   echo ""
   echo "file-import failed"
   echo ""
   exit 1
fi

sleep 1


echo "------------------------------"
echo " sync with second archive..."
echo "------------------------------"
if ! $EXEC/src/apps/util/archive-sync /tmp/objectify_test/private2.obj; then
   echo ""
   echo "archive-sync failed"
   echo ""
   exit 1
fi

sleep 2


echo "-----------------------"
echo " import more files..."
echo "-----------------------"

if ! $EXEC/src/apps/file/file-import x5*; then
   echo ""
   echo "file-import failed"
   echo ""
   exit 1
fi

sleep 1

if ! $EXEC/src/apps/file/file-import x7*; then
   echo ""
   echo "file-import failed"
   echo ""
   exit 1
fi

sleep 1

if ! $EXEC/src/apps/file/file-import x8*; then
   echo ""
   echo "file-import failed"
   echo ""
   exit 1
fi

sleep 1

if ! $EXEC/src/apps/file/file-import x9*; then
   echo ""
   echo "file-import failed"
   echo ""
   exit 1
fi

sleep 2

echo "------------------------------------"
echo " sync with second archive again..."
echo "------------------------------------"
if ! $EXEC/src/apps/util/archive-sync /tmp/objectify_test/private2.obj; then
   echo ""
   echo "archive-sync failed"
   echo ""
   exit 1
fi

sleep 2


echo "-----------------------------------------"
echo " verify it won't do it the wrong way..."
echo "-----------------------------------------"
if $EXEC/src/apps/util/archive-sync /tmp/objectify_test/private3.obj /tmp/objectify_test/private2.obj; then
   echo ""
   echo "archive-sync failed"
   echo ""
   exit 1
fi


echo "------------------------------------"
echo " sync with the third archive..."
echo "------------------------------------"
if ! $EXEC/src/apps/util/archive-sync /tmp/objectify_test/private2.obj /tmp/objectify_test/private3.obj; then
   echo ""
   echo "archive-sync failed"
   echo ""
   exit 1
fi

sleep 2


echo ""
echo "All tests passed!"
echo ""


exit 0

