/*
--          This file is part of the New World OS and Objectify projects
--         Copyright (C) 2005, 2006, 2007, 2008, 2009, 2010  QRW Software
--               J. Scott Edwards - j.scott.edwards.nwos@gmail.com 
--
--   This program is free software: you can redistribute it and/or modify
--   it under the terms of the GNU General Public License as published by
--   the Free Software Foundation, either version 3 of the License, or
--   (at your option) any later version.
--
--   This program is distributed in the hope that it will be useful,
--   but WITHOUT ANY WARRANTY; without even the implied warranty of
--   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
--   GNU General Public License for more details.
--
--   You should have received a copy of the GNU General Public License
--   along with this program, in the file LICENSE.  If not, see 
--   <http://www.gnu.org/licenses/>.
--
--   For the latest information, source code (SVN), releases, and bug tracking
--   go to:
--      http://savannah.nongnu.org/projects/objectify
--
--   For releases from Alpha_30 and up, bug and feature request tracking go to:
--      http://sourceforge.net/projects/objectify
--
--   For older bug tracking, releases and source code (CVS) prior to the
--   Alpha_30 release go to:
--      http://sourceforge.net/projects/nwos
--
--   Other related websites:
--      http://www.qrwsoftware.com
--      http://www.worldwide-database.org
--
--   You can also contact me via paper mail at:
--
--      QRW Software
--      P.O. Box 27511
--      Salt Lake City, UT 84127-0511, USA.
--
--   $Author: jsedwards $
--   $Date: 2011-11-05 13:31:55 -0600 (Sat, 05 Nov 2011) $
--   $Revision: 4924 $
--
--   NOTE: Subversion does not support the Log keyword so I have removed the
--   logs that were here when I was using CVS.  Use the "svn log" command to
--   see the revision history of this file, the disk_io.h file, and the
--   objectify_private.h file.
--   (See http://subversion.tigris.org/faq.html#log-in-source)
--
*/


#ifndef SECURITY_H
#define SECURITY_H

#include "reference.h"
#include "types.h"


#define IVEC_SIZE 8  /* don't know for sure, the man page doesn't say, i made the buffer larger and looked at if afterwards. */

#define NUM_STORED_SEQ 4096     /* number of sequence tables that are stored, 4096 = 1 MB worth and uses 1 MB worth of RAM */


extern void nwos_get_key_from_password(uint8 key[], size_t key_size);
extern void nwos_setup_from_big_key(uint8 big_key[16 + 8 + 4], ObjRef* root_object_ref);

extern bool nwos_read_block_from_disk_and_decrypt(ObjRef* ref, void* object, size_t size, uint8 ivec[IVEC_SIZE], int seq);
extern bool nwos_read_block_from_disk_and_old_decrypt(ObjRef* ref, void* object, size_t size, uint8 ivec[IVEC_SIZE], int seq);
extern void nwos_write_block_to_disk_and_encrypt(ObjRef* ref, void* object, size_t size, uint8 ivec[IVEC_SIZE], int seq);


#endif

