--
--          This file is part of the New World OS and Objectify projects
--                  Copyright (C) 2008, 2009, 2011  QRW Software
--               J. Scott Edwards - j.scott.edwards.nwos@gmail.com 
--
--   This program is free software: you can redistribute it and/or modify
--   it under the terms of the GNU General Public License as published by
--   the Free Software Foundation, either version 3 of the License, or
--   (at your option) any later version.
--
--   This program is distributed in the hope that it will be useful,
--   but WITHOUT ANY WARRANTY; without even the implied warranty of
--   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
--   GNU General Public License for more details.
--
--   You should have received a copy of the GNU General Public License
--   along with this program, in the file LICENSE.  If not, see 
--   <http://www.gnu.org/licenses/>.
--
--   For the latest information, source code (SVN), releases, and bug tracking
--   go to:
--      http://savannah.nongnu.org/projects/objectify
--
--   For releases from Alpha_30 and up, bug and feature request tracking go to:
--      http://sourceforge.net/projects/objectify
--
--   For older bug tracking, releases and source code (CVS) prior to the
--   Alpha_30 release go to:
--      http://sourceforge.net/projects/nwos
--
--   Other related websites:
--      http://www.qrwsoftware.com
--      http://www.worldwide-database.org
--
--   You can also contact me via paper mail at:
--
--      QRW Software
--      P.O. Box 27511
--      Salt Lake City, UT 84127-0511, USA.
--
--   $Author: jsedwards $
--   $Date: 2011-05-17 19:02:18 -0600 (Tue, 17 May 2011) $
--   $Revision: 4901 $
--
--   NOTE: Subversion does not support the Log keyword so I have removed the
--   logs that were here when I was using CVS.  Use the "svn log" command to
--   see the revision history of this file.
--   (See http://subversion.tigris.org/faq.html#log-in-source)
--


class REFERENCE

inherit
   GENERAL
      redefine 
         is_equal, copy
      end


creation make, copy

feature

   storage: NATIVE_ARRAY[CHARACTER]

   make is
      do
         storage := storage.calloc(4);
      end

   copy(other: like Current) is
      do
         make
         storage.put(other.storage.item(0), 0)
         storage.put(other.storage.item(1), 1)
         storage.put(other.storage.item(2), 2)
         storage.put(other.storage.item(3), 3)
      end

   is_void: BOOLEAN is
      do
         Result := storage.item(0).code = 0
                      and then
                   storage.item(1).code = 0
                      and then
                   storage.item(2).code = 0
                      and then
                   storage.item(3).code = 0
      end

   is_equal(other: like Current): BOOLEAN is
      do
--         Result := storage.is_equal(other.storage)  Why doesn't this work??

           Result := storage.item(0) = other.storage.item(0) and
                     storage.item(1) = other.storage.item(1) and
                     storage.item(2) = other.storage.item(2) and
                     storage.item(3) = other.storage.item(3)
      end

   append_in(str: STRING) is
      do
         storage.item(0).to_hexadecimal_in(str)
         storage.item(1).to_hexadecimal_in(str)
         storage.item(2).to_hexadecimal_in(str)
         storage.item(3).to_hexadecimal_in(str)
      end

   dump is
      local
         two_digit_hex: INTEGER_FORMAT
      do
         two_digit_hex.set_width(2)
         two_digit_hex.set_zero_fill
         two_digit_hex.set_hexadecimal

         std_output.put_integer_format(storage.item(0).code, two_digit_hex.to_integer);
         std_output.put_integer_format(storage.item(1).code, two_digit_hex.to_integer);
         std_output.put_integer_format(storage.item(2).code, two_digit_hex.to_integer);
         std_output.put_integer_format(storage.item(3).code, two_digit_hex.to_integer);
         std_output.put_new_line;
      end

   object_class: REFERENCE is
      do
         !!Result.make
         nwos_get_object_class(to_external, Result.to_external)
      end

   to_external: POINTER is
         -- Gives C access to the internal `storage' (may be dangerous).
      do
         Result := storage.to_external;
      end;

   nwos_get_object_class(ref, class_ref: POINTER) is
      external "C"
      end


end

