/*
--          This file is part of the New World OS and Objectify projects
--               Copyright (C) 2007, 2008, 2009, 2010  QRW Software
--               J. Scott Edwards - j.scott.edwards.nwos@gmail.com 
--
--   This program is free software: you can redistribute it and/or modify
--   it under the terms of the GNU General Public License as published by
--   the Free Software Foundation, either version 3 of the License, or
--   (at your option) any later version.
--
--   This program is distributed in the hope that it will be useful,
--   but WITHOUT ANY WARRANTY; without even the implied warranty of
--   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
--   GNU General Public License for more details.
--
--   You should have received a copy of the GNU General Public License
--   along with this program, in the file LICENSE.  If not, see 
--   <http://www.gnu.org/licenses/>.
--
--   For the latest information, source code (SVN), releases, and bug tracking
--   go to:
--      http://savannah.nongnu.org/projects/objectify
--
--   For releases from Alpha_30 and up, bug and feature request tracking go to:
--      http://sourceforge.net/projects/objectify
--
--   For older bug tracking, releases and source code (CVS) prior to the
--   Alpha_30 release go to:
--      http://sourceforge.net/projects/nwos
--
--   Other related websites:
--      http://www.qrwsoftware.com
--      http://www.worldwide-database.org
--
--   You can also contact me via paper mail at:
--
--      QRW Software
--      P.O. Box 27511
--      Salt Lake City, UT 84127-0511, USA.
--
--   $Author: jsedwards $
--   $Date: 2012-04-15 11:57:32 -0600 (Sun, 15 Apr 2012) $
--   $Revision: 4998 $
--
--   NOTE: Subversion does not support the Log keyword so I have removed the
--   logs that were here when I was using CVS.  Use the "svn log" command to
--   see the revision history of this file.
--   (See http://subversion.tigris.org/faq.html#log-in-source)
--
*/

/* This program adds names to the public objects. */


#include <stdio.h>

#include "objectify.h"



static char* extra_names[] = 
{
  "best", "bost", "brill", "carlton", "davidson", "learned", "lords", "nadine", "nicki", "olivas", "olsen", "olson" "patten", "ric", "roberta", "starkey", "sumner", "thorn", "traci"
};


#define NUM_EXTRA_NAMES (sizeof(extra_names) / sizeof(char*))



int main(int argc, char* argv[])
{
    int i;
    ObjRef ref;
    char msg[128];


    nwos_log_arguments(argc, argv);

    nwos_initialize_objectify(PUBLIC, NULL);

    for (i = 0; i < NUM_EXTRA_NAMES; i++)
    {
	snprintf(msg, sizeof(msg), "Creating name: %s", extra_names[i]);
	nwos_log(msg);

	nwos_create_name(extra_names[i], &ref);
    }

    nwos_terminate_objectify();

    return 0;
}

