#!/bin/bash

# Directory containing .po files
PO_DIR="../po"

# Directory containing the .pot file
POT_DIR="../po/pot"

# Name of the .pot file
POT_FILE="kickshaw.pot"

# Loop through all .po files in the PO_DIR
for po_file in "$PO_DIR"/*.po; do
    # Extract the language code from the file name
    lang=$(basename "$po_file" .po)

    # Run msgmerge command
    msgmerge --update "$po_file" "$POT_DIR/$POT_FILE"

    echo "Updated $lang.po with new translations from $POT_FILE"
done

echo "All .po files have been updated."
