#!/bin/bash

# Directory containing .po files
PO_DIR="../po"

# Directory to output .mo files
OUTPUT_DIR="txts/translations"

# Loop through all .po files in the PO_DIR
for po_file in "$PO_DIR"/*.po; do
    # Extract the language code from the file name
    lang=$(basename "$po_file" .po)

    # Create output directory for the language if it doesn't exist
    mkdir -p "$OUTPUT_DIR/$lang/LC_MESSAGES"

    # Run msgfmt command
    msgfmt --output-file="$OUTPUT_DIR/$lang/LC_MESSAGES/kickshaw.mo" "$po_file"
done

echo "All .po files have been processed."
