/*  GNU Ocrad - Optical Character Recognition program
    Copyright (C) 2003, 2004 Antonio Diaz Diaz.

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
*/

namespace Ocrad
  {
  void internal_error( const char * msg ) throw() __attribute__ ((noreturn));
  bool similar( int a, int b, int percent_dif, int abs_dif = 1 ) throw();
  }


class Charset
  {
  int _charset;

public:
  enum Value { ascii = 1, iso_8859_9 = 2, iso_8859_15 = 4 };

  Charset() throw() : _charset( 0 ) {}
  bool enable( const char * name ) throw();
  bool enabled( Value cset ) const throw();
  bool only( Value cset ) const throw();
  void show_error( const char * arg ) const throw();
  };


class Transformation
  {
public:
  enum Type { none, rotate90, rotate180, rotate270,
              mirror_lr, mirror_tb, mirror_d1, mirror_d2 };
private:
  Type _type;

public:
  Transformation() throw() : _type( none ) {}
  bool set( const char * name ) throw();
  Type type() const throw() { return _type; }
  void show_error( const char * arg ) const throw();
  };


struct Control
  {
  enum Format { byte, utf8 };

  Charset charset;
  Format format;
  FILE *outfile, *exportfile;
  int debug_level;
  char filetype;
  bool verbose;

  Control() throw()
    : format( byte ), outfile( stdout ), exportfile( 0 ),
      debug_level( 0 ), filetype( 0 ), verbose( false )
    {}
  bool set_format( const char * name ) throw();
  };
