/*  ocrad - Optical Character Recognition program
    Copyright (C) 2003 Antonio Diaz Diaz.
*/

class Profile
  {
public:
  enum type { left, top, right, bottom, height, width, zheight, zwidth };

private:
  const Block * _block;		// Block to witch this profile belongs
  const Blockmap * _blockmap;	// Blockmap to which the block belongs
  type _type;
  bool valid, valid_max, valid_min, valid_mean, valid_range;
  bool valid_isconcave, valid_isconvex;
  bool valid_isflat, valid_isflats, valid_ispit, valid_isupit;
  bool valid_isvpit, valid_istip;
  int _limit, _max, _min, _mean, _range;
  bool _isconcave, _isconvex, _isflat, _isflats, _ispit, _isupit;
  bool _isvpit, _istip;
  std::vector< int > data;
  void initialize() throw();
  int mean() throw();

public:
  Profile( const Block & b, type t ) throw();

  const Block * block() const throw() { return _block; }
  const Blockmap * blockmap() const throw() { return _blockmap; }

  int limit() throw();
  int max() throw();
  int min() throw();
  int operator[]( int i ) throw();
  int pos( int p ) throw();
  int range() throw();
  int samples() throw()
    { if( !valid ) initialize(); return data.size(); }

  bool increasing( int i = 1 ) throw();
  bool decreasing( int i = 1 ) throw();
  bool isconvex() throw();
  bool isflat() throw();
  bool isflats() throw();
  bool ispit() throw();
  bool isupit() throw();
  bool isvpit() throw();
  bool istip() throw();
  bool isctip( int cpos = 50 ) throw();
  int  imaximum() throw();
  int  iminimum( int m = 0, int th = -1 ) throw();
  int  maxima() throw();
  int  minima( int th = -1 ) throw();
  bool straight( int * dy ) throw();
  };
