/*  GNU OCRAD - Optical Character Recognition program
    Copyright (C) 2003 Antonio Diaz Diaz.

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

class Profile
  {
public:
  enum type { left, top, right, bottom, height, width, zheight, zwidth };

private:
  const Block * _block;		// Block to witch this profile belongs
  const Blockmap * _blockmap;	// Blockmap to which the block belongs
  type _type;
  bool valid, valid_max, valid_min, valid_mean, valid_range;
  bool valid_isconcave, valid_isconvex;
  bool valid_isflat, valid_isflats, valid_ispit, valid_isupit;
  bool valid_isvpit, valid_istip;
  int _limit, _max, _min, _mean, _range;
  bool _isconcave, _isconvex, _isflat, _isflats, _ispit, _isupit;
  bool _isvpit, _istip;
  std::vector< int > data;
  void initialize() throw();
  int mean() throw();

public:
  Profile( const Block & b, type t ) throw();

  const Block * block() const throw() { return _block; }
  const Blockmap * blockmap() const throw() { return _blockmap; }

  int limit() throw();
  int max() throw();
  int min() throw();
  int operator[]( int i ) throw();
  int pos( int p ) throw();
  int range() throw();
  int samples() throw()
    { if( !valid ) initialize(); return data.size(); }

  bool increasing( int i = 1 ) throw();
  bool decreasing( int i = 1 ) throw();
  bool isconcave() throw();
  bool isconvex() throw();
  bool isflat() throw();
  bool isflats() throw();
  bool ispit() throw();
  bool isupit() throw();
  bool isvpit() throw();
  bool istip() throw();
  bool isctip( int cpos = 50 ) throw();
  int  imaximum() throw();
  int  iminimum( int m = 0, int th = -1 ) throw();
  int  maxima() throw();
  int  minima( int th = -1 ) throw();
  bool straight( int * dy ) throw();
  };
