/*  GNU OCRAD - Optical Character Recognition program
    Copyright (C) 2003 Antonio Diaz Diaz.

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

class Textline
  {
  mutable std::vector< Character > data;
  int find_space( int begin ) const throw();

public:
  Textline() throw() {}

  const Character & add_character( const Character & c ) throw();
  void insert_character( int i, const Character & ) throw();
  void delete_character( int i ) throw();
  const Character & shift_character( const Character & c ) throw();
  void swap_characters( int i, int j ) throw();
  Character & character( int i ) const throw();

  const Character & front() const throw() { return data.front(); }
  const Character & back() const throw() { return data.back(); }
  int characters() const throw() { return data.size(); }

  int mean_height() const throw();
  int mean_height1() const throw();
  int mean_width() const throw();
  int mean_gap_width() const throw();
  int mean_hcenter() const throw();
  int mean_vcenter() const throw();

  void join( Textline & l ) throw();
  void print( FILE * outfile, bool graph, bool recursive ) const throw();
  void xprint( FILE * exportfile ) const throw();

  void recognize1() const throw();
  void recognize2() throw();
  };
