# Copyright (C) 2004  Alex Schroeder <alex@emacswiki.org>
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the
#    Free Software Foundation, Inc.
#    59 Temple Place, Suite 330
#    Boston, MA 02111-1307 USA

$ModulesDescription .= '<p>$Id: markup.pl,v 1.10 2004/08/18 13:01:48 as Exp $</p>';

push(@MyRules, \&MoinRules);

sub MoinRules {
  if (m/\G__/gc) {
    return (defined $HtmlStack[0] && $HtmlStack[0] eq 'u')
      ? CloseHtmlEnvironment() : AddHtmlEnvironment('u');
  } elsif (m/\G,,/gc) {
    return (defined $HtmlStack[0] && $HtmlStack[0] eq 'sub')
      ? CloseHtmlEnvironment() : AddHtmlEnvironment('sub');
  } elsif (m/\G\^/gc) {
    return (defined $HtmlStack[0] && $HtmlStack[0] eq 'sup')
      ? CloseHtmlEnvironment() : AddHtmlEnvironment('sup');
  } elsif ($bol && m/\G\{\{\{((.*\n)+)+/gc) {
    return (AddHtmlEnvironment('code'));
  } elsif ($bol && m/\G\{\{\{/gc) {
    return (AddHtmlEnvironment('code'));
  }
  # from the usemod extension:
  # emphasis and strong emphasis using '' and '''
  elsif (defined $HtmlStack[0] && $HtmlStack[1] && $HtmlStack[0] eq 'em'
	 && $HtmlStack[1] eq 'strong' and m/\G\'\'\'\'\'/cg) { # close either of the two
    return CloseHtmlEnvironment() . CloseHtmlEnvironment();
  } elsif (m/\G\'\'(?=[^\'])/cg) { # traditional wiki syntax for ''emph''
    return (defined $HtmlStack[0] && $HtmlStack[0] eq 'em')
      ? CloseHtmlEnvironment() : AddHtmlEnvironment('em');
  } elsif (m/\G\'\'\'/cg) { # traditional wiki syntax for '''strong'''
    return (defined $HtmlStack[0] && $HtmlStack[0] eq 'strong')
      ? CloseHtmlEnvironment() : AddHtmlEnvironment('strong');
  }
  return undef;
}





print '[moin module]';

system('/bin/rm -rf /tmp/oddmuse');
die "Cannot remove /tmp/oddmuse!\n" if -e '/tmp/oddmuse';
mkdir '/tmp/oddmuse';
mkdir '/tmp/oddmuse/modules';
open(F,'>/tmp/oddmuse/config');
print F "\$SurgeProtection = 0;\n";
close(F);
symlink('/home/alex/src/oddmuse/modules/moin.pl',
	'/tmp/oddmuse/modules/moin.pl') or die "Cannot symlink: $@";

%Test = split('\n',<<'EOT');
__Mixing__ ''italics'' and '''bold''':
<u>Mixing</u> <em>italics</em> and <strong>bold</strong>:
* '''''Mix''' at the beginning''\n* '''''Mix'' at the beginning'''\n* '''Mix at the ''end'''''\n* ''Mix at the '''end'''''
<ul><li><em><strong>Mix</strong> at the beginning</em></li><li><strong><em>Mix</em> at the beginning</strong></li><li><strong>Mix at the <em>end</em></strong></li><li><em>Mix at the <strong>end</strong></em></li></ul>
You might recall ''a''^2^ `+` ''b''^2^ `=` ''c''^2^ from your math lessons, unless you head is filled with H,,2,,O.
You might recall <em>a</em><sup>2</sup> <tt>+</tt> <em>b</em><sup>2</sup> <tt>=</tt> <em>c</em><sup>2</sup> from your math lessons, unless you head is filled with H<sub>2</sub>O.
An {{{inline code sequence}}} has the start and end markers on the same line. Or you use `backticks`.
An <tt>inline&nbsp;code&nbsp;sequence</tt> has the start and end markers on the same line. Or you use <tt>backticks</tt>.
A code display has them on different lines: {{{\n'''No''' markup here!\n}}}
A code display has them on different lines: <pre>\n'''No''' markup here!\n</pre>
EOT

run_tests();
