# Count the new new domains added in URLs.
# www.FOO.BAR
# http://foo.bar

sub SpamAdded {
  my ($old, $new) = @_;
  my %domains = ();
  while ($new =~ m!(\.|http://)([-a-z0-9]+\.[a-z][a-z][a-z]?)\b!ig) {
    $domains{lc($2)}++;
  }
  while ($old =~ m!(\.|http://)([-a-z0-9]+\.[a-z][a-z][a-z]?)\b!ig) {
    $domains{lc($2)}--;
  }
  my $max = 0;
  foreach my $i (values(%domains)) {
    $max = $i if $i > $max;
  }
  if ($max > 2) {
    return "Spam!";
  }
}

# Test Code

use LWP::UserAgent;

sub GetRaw {
  my $uri = shift;
  my $ua = LWP::UserAgent->new;
  my $response = $ua->get($uri);
  return $response->content;
}

# http://www.emacswiki.org/cgi-bin/wiki?action=browse&diff=1&id=SiteMap&revision=538&diffrevision=537&Vergleichen=Vergleichen

sub Test {
  my ($id, $start, $stop) = @_;
  print $id, ":\n";
  for (my $i = $start; $i < $stop; $i++) {
    my $j = $i + 1;
    print $i, ' -> ', $j, ' ',
      SpamAdded(GetRaw("http://www.emacswiki.org/cgi-bin/wiki?action=browse;id=$id;revision=$i"),
		GetRaw("http://www.emacswiki.org/cgi-bin/wiki?action=browse;id=$id;revision=$j")),
		  "\n";
    sleep(5);
  }
}

Test('SiteMap', 537, 557);
