#
# Copyright (C) 2003 Dmitry Fedorov <fedorov@inp.nsk.su>
#
# This file is part of Offmirror.
#
# Offmirror is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# Offmirror is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with Offmirror; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

package OffMirror::User;

require 5.003;
use strict;

use FindBin;
use lib "$FindBin::Bin";
use OffMirror::Cache;


BEGIN
{
    use vars qw($VERSION @ISA @EXPORT);

    use Exporter;

    $VERSION = do { my @r = (q$Revision: 1.4 $ =~ /\d+/g); sprintf "%d."."%02d" x $#r, @r };

    @ISA = ('Exporter');

    @EXPORT = qw( &get_usr_name &get_usr_id &warn_no_user_once
		  &get_grp_name &get_grp_id &warn_no_group_once );
}


#+ get_usr_name()
my $uid_name_cache = OffMirror::Cache->new(\&_get_usr_name);

sub _get_usr_name($)
{
    my $uid = shift;
    my $name = getpwuid($uid);
    $name = $uid unless defined $name;
    return $name;
}

# name = get_usr_name(uid)
# on failrure returns uid number from arg
sub get_usr_name($)
{
    return $uid_name_cache->get_value(shift);
}
#- get_usr_name()


#+ get_grp_name()
my $gid_name_cache = OffMirror::Cache->new(\&_get_grp_name);

sub _get_grp_name($)
{
    my $gid = shift;
    my $name = getgrgid($gid);
    $name = $gid unless defined $name;
    return $name;
}

# name = get_grp_name(gid)
# on failrure returns gid number from arg
sub get_grp_name($)
{
    return $gid_name_cache->get_value(shift);
}
#- get_grp_name()


#+ get_usr_id()
my $name_uid_cache = OffMirror::Cache->new(\&_get_usr_id);

sub _get_usr_id($)
{
    my $uid = getpwnam(shift);
    $uid = -1 unless defined $uid;
    return $uid;
}

# uid = get_usr_id(name)
# on failrure returns -1
sub get_usr_id($)
{
    return $name_uid_cache->get_value(shift);
}
#- get_usr_id()


#+ get_grp_id()
my $name_gid_cache = OffMirror::Cache->new(\&_get_grp_id);

sub _get_grp_id($)
{
    my $gid = getgrnam(shift);
    $gid = -1 unless defined $gid;
    return $gid;
}

# gid = get_grp_id(name)
# on failrure returns -1
sub get_grp_id($)
{
    return $name_uid_cache->get_value(shift);
}
#- get_grp_id()


#+ one-time no user warning
my $no_user = OffMirror::Cache->new(\&_no_user);

sub _no_user($)
{
    my $user = shift;
    print STDERR "No such user: $user\n";
    return 1;
}

sub warn_no_user_once($)
{
    $no_user->get_value(shift);
}
#- one-time no user warning


#+ one-time no group warning
my $no_group = OffMirror::Cache->new(\&no_group);

sub _no_group($)
{
    my $group = shift;
    print STDERR "No such group: $group\n";
    return 1;
}

sub warn_no_group_once($)
{
    $no_group->get_value(shift);
}
#- one-time no group warning



1;

