#!/usr/bin/perl -w
#
# Copyright (C) 2003,2004,2006 Dmitry Fedorov <dm.fedorov@gmail.com>
#
# This file is part of Offmirror.
#
# Offmirror is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# Offmirror is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with Offmirror; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02110-1301  USA


=head1 NAME

offmirror-difflist2tar - convert offmirror diff list to null-terminated
file list for GNU tar.

=head1 SYNOPSIS

offmirror-difflist2tar [-help]

=head1 DESCRIPTION

This program is part of files tree offline mirroring utility package,
which is used to synchronize file trees without any direct connection
between them.

This program reads from stdin file diff list produced by offmirror-diff,
selects records with 'copy' action field and outputs simple zero-terminated
file list to stdout for GNU tar.

Directories are skipped.

=cut

require 5.004;
use strict;
local $^W=1; # use warnings only since 5.006

use integer;
use Getopt::Long;

use FindBin;
use lib "$FindBin::Bin/../lib";
use OffMirror::FileList;


my $progname = 'offmirror-difflist2tar';

sub usage
{
	warn "\n".join(" ", @_)."\n" if @_;
	warn <<EOF;

Usage: $progname [-help]

For details, see man page.
EOF
	exit(1);
}


=head1 OPTIONS

=over 4

=item -help

Display a usage summary.

=back

=head1 SEE ALSO

L<offmirror(1)>

=cut


my $help=0;

GetOptions(
	'help'		=> \$help
) or usage;

usage if $help;

shift @ARGV and usage("extra parameter specified");	# shouldn't have args

do_list();

exit 0;


sub do_list
{
    my $list = OffMirror::FileList::new(*STDIN);
    $list->parse_first();

    my ($r, $fname);
    while ( (($r, $fname) = $list->parse_line()), defined $r )
    {
	next if $r->field('action') ne 'c' or $r->field('type') eq 'd';

	if ( ! print($fname."\0") )
	{
	    die "can't write to tar pipe: $!";
	}
    }
}


=head1 AUTHOR

Dmitry Fedorov <dm.fedorov@gmail.com>

=head1 COPYRIGHT

Copyright (C) 2003,2004,2006 Dmitry Fedorov <dm.fedorov@gmail.com>

=head1 LICENSE

This program is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2 of the License,
or (at your option) any later version.

=head1 DISCLAIMER

The author disclaims any responsibility for any mangling of your system
etc, that this script may cause.

=cut
