#
# Copyright (C) 2003,2004,2006,2008 Dmitry Fedorov <dm.fedorov@gmail.com>
#
# This file is part of Offmirror.
#
# Offmirror is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# Offmirror is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with Offmirror; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02110-1301  USA

package OffMirror::Cache;

require 5.004;
use strict;
local $^W=1; # use warnings only since 5.006


BEGIN
{
    use vars qw($VERSION);
    $VERSION = do { my @r = (q$Revision: 1.21 $ =~ /\d+/g); sprintf "%d."."%02d" x $#r, @r };
}


# ctor
# $objref = OffMirror::Cache::new( func_ref )
sub new(;&)
{
    my $self =
    {
	'_func'  => $_[0],
	'_cache' => {}
    };

    return bless($self, __PACKAGE__);
}


sub clear_cache($)
{
    $_[0]->{'_cache'} = {};
}


sub get_value($$)
{
    my ($this, $key) = @_;

    my $hr = $this->{'_cache'};

    return $hr->{$key} if exists $hr->{$key};	# cached value

    my $func = $this->{'_func'};

    if ( defined $func )
    {
	my $val = &$func($key);
	$hr->{$key} = $val;
	return $val;
    }

    return undef;
}


sub add($$$)
{
    my ($this, $key, $val) = @_;

    $this->{'_cache'}->{$key} = $val;
}


sub del_key($$)
{
    my ($this, $key) = @_;

    delete $this->{'_cache'}->{$key}
}


1;
