#
# Copyright (C) 2003,2004,2006,2008 Dmitry Fedorov <dm.fedorov@gmail.com>
#
# This file is part of Offmirror.
#
# Offmirror is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# Offmirror is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with Offmirror; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02110-1301  USA

package OffMirror::Misc;

require 5.004;
use strict;
local $^W=1; # use warnings only since 5.006


BEGIN
{
    use Exporter;
    use vars qw($VERSION @ISA @EXPORT);

    $VERSION = do { my @r = (q$Revision: 1.7 $ =~ /\d+/g); sprintf "%d."."%02d" x $#r, @r };
    @ISA = ('Exporter');
    @EXPORT = qw( &prepare_compressed_file_name_for_open
		  &encode_bad_name &decode_bad_name );
}


sub prepare_compressed_file_name_for_open($)
{
    my $file = $_[0];

    $file =~ s/^(.*\.(gz|z|Z|zip))$/gzip -dc < $1|/
	or
    $file =~ s/^(.*\.(bz2|bz))$/bzip2 -dc < $1|/
	or
    $file =~ s/^(.*)$/< $1/;

    return $file;
}

sub encode_bad_name($)
{
    my $res = $_[0];
    $res =~ s/([\000-\040\177-\377=])/sprintf("=%02X", ord($1))/seg;

    return $res;
}

sub decode_bad_name($)
{
    my $res = $_[0];
    $res =~ s/=([\da-fA-F]{2})/pack("C", hex($1))/ge;

    return $res;
}


1;

