/************************************************************************
 *                                                                      *
 * OFE - OFE ForEver - ncurses file editor for GNU/Linux                *
 * (c) 2001, 2002 Slawomir Strumecki, Raphael Bugajewski, Marcus vA     *
 *                                                                      *
 * This program is free software, you can redistribute it and/or modify *
 * it under the terms of the GNU General Public License as published by *
 * the Free Software Foundation; either version 2 of the License, or    *
 * (at your option) any later version.                                  *
 *                                                                      *
 * This program is distributed in the hope that it will be useful,      *
 * but WITHOUT ANY WARRANTY; without even the implied warranty of       *
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the        *
 * GNU General Public License for more details.                         *
 *                                                                      *
 * You should have received a copy of the GNU General Public License    *
 * along with this program; if not, write to the Free Software          *
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 *
 *                                                                      *
 ************************************************************************
 *                                                                      *
 * If you want to contact us, please use the following address(es):     *
 *                                                                      *
 *     Raphael Bugajewski               Slawomir Strumecki              *
 *     Kl. Mittelstr. 1                 mailto: <logospam@poczta.fm>    *
 *     13585 Berlin / Germany                                           *
 *     Tel.: +49 (175) 331 93 92                                        *
 *     mailto: <born@bugajewski.de>                                     *
 *                                                                      *
 ************************************************************************/

#include <stdlib.h>
#include "ofe.h"
#include "file.h"
#include "ui.h"

#ifdef MODULE
  int ofe (int argc, char *argv[])
#else  
  int main (int argc, char *argv[]) 
#endif /* MODULE */
{
  int key;
  /* variables */
  WINDOW *editor_box;
  WINDOW *editor;
  contentPtr file_content = NULL;
  int x = 5, y, max_y, max_x;

  /* init */
  initscr ();
  cbreak ();
  curs_set (0);
  noecho ();

  keypad (editor, TRUE);
  keypad (stdscr, TRUE);
  
  refresh ();

  /* new window */
  editor_box = create_new_win_with_box (LINES, COLS, 0, 0);

  editor = create_new_win (LINES - 2, COLS - 2 , 1, 1);
  getmaxyx (editor, max_y, max_x);
  /* we like to scroll */
  scrollok (editor, TRUE);

  wsetscrreg (editor, 0, LINES);

  /* here we will open the file and read all stuff */
  if ((file_content = (content *) malloc (sizeof (content))) == NULL)
    {
      printf ("Memmory could not be allocated - exiting...\n");
      return 1;
    }

  file_content = read_file (argv[1]);
  
  /* initial display */
  for (y = 0; (y < max_y) && (file_content->next != NULL); y++,
	 file_content = file_content->next)
    {
      mvwprintw (editor, y, 0, file_content->text);
      wrefresh (editor);
    }
  
  /* wait for user reaction */
  while (1)
    {
      key = getch();
      
      /* end viewer */
      if (key == KEY_F(1))
	{
	  destroy_win (editor);
	  endwin ();
	  return 0;
	}
      /* scroll down */
      if ((key == KEY_DOWN) && (file_content->next != NULL))
	{
	  /* set the contentPtr to the right one */
	  getyx (editor, y, x);
	  while (y < max_y)
	    {
	      if (file_content->next != NULL)
		{
		  file_content = file_content->next;
		}
	      y++;
	    }
	  /* display it */
	  mvwprintw (editor, max_y - 1, 0, file_content->text);
	  wrefresh (editor);
	}
      /* scroll up */
      if ((key == KEY_UP) && (file_content->prev != NULL))
	{
	  getyx (editor, y, x);
	  /* same as above, but reversed */
	  while (y > 0)
	    {
	      if (file_content->prev != NULL)
		{
		  file_content = file_content->prev;
		}
	      y--;
	    }
	  /* same as above, but reversed */
	  move (1, 1);
  	  wscrl (editor, -1);
	  mvwprintw (editor, 0, 0, file_content->text);
	  wrefresh (editor);
	}
    }
}

