/************************************************************************
 *                                                                      *
 * Open File Manager - ncurses file manager for GNU/Linux               *
 * (c) 2001, 2002 Slawomir Strumecki, Raphael Bugajewski                *
 *                                                                      *
 * This program is free software, you can redistribute it and/or modify *
 * it under the terms of the GNU General Public License as published by *
 * the Free Software Foundation; either version 2 of the License, or    *
 * (at your option) any later version.                                  *
 *                                                                      *
 * This program is distributed in the hope that it will be useful,      *
 * but WITHOUT ANY WARRANTY; without even the implied warranty of       *
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the        *
 * GNU General Public License for more details.                         *
 *                                                                      *
 * You should have received a copy of the GNU General Public License    *
 * along with this program; if not, write to the Free Software          *
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 *
 *                                                                      *
 ************************************************************************
 *                                                                      *
 * If you want to contact us, please use the following address(es):     *
 *                                                                      *
 *     Raphael Bugajewski               Slawomir Strumecki              *
 *     Kl. Mittelstr. 1                 mailto: <logospam@poczta.fm>    *
 *     13585 Berlin / Germany                                           *
 *     Tel.: +49 (175) 331 93 92                                        *
 *     mailto: <born@bugajewski.de>                                     *
 *                                                                      *
 ************************************************************************/

#include <stdlib.h>
#include <stdio.h>

#if defined(DEBUG)

typedef struct tmanode{
    size_t size;
    void *ptr;
    struct tmanode *next;
    struct tmanode *prev;
} MANode;  /* memory allocation node */ 

static MANode *MAList_hd=NULL;    /* head of list */
static MANode *MAList_tl=NULL;    /* last element in list */

int total_malloced=0;

void *xmalloc(size_t size)
{
    void *ptr;
    MANode *mn=NULL;
    
    ptr=NULL;
    ptr=malloc(size);
    if (ptr!=NULL) {
	mn=(MANode *)malloc(sizeof(MANode));
	if (mn!=NULL) {
	    total_malloced+=size;
	    mn->size=size;
	    mn->ptr=ptr;
	    mn->next=NULL;
	    if (MAList_tl!=NULL) {
		mn->prev=MAList_tl;
		MAList_tl->next=mn;
		MAList_tl=mn;
	    } else {
		mn->prev=NULL;
		MAList_hd=mn;
		MAList_tl=mn;
	    }
	}
    }
    return ptr;
}

void xfree(void *ptr)
{
    MANode *p=MAList_tl;
    if (ptr!=NULL) {
	while(p!=NULL) {
	    if (p->ptr==ptr) {
		free(ptr);
		total_malloced-=p->size;

		if (p->prev!=NULL) p->prev->next=p->next;
		else { /*  if the first element in the list */
		    if (MAList_tl==p) MAList_tl=p->next; 
		    MAList_hd=p->next;		
		}
		if (p->next!=NULL) p->next->prev=p->prev;
		else {  /* if the last element in the list */
		    if (MAList_hd==p) MAList_hd=p->prev; 
		    MAList_tl=p->prev;
		}
		free(p);
		return;
	    }
	    p=p->prev;
	}
	free(ptr);
    }
    
    return;
}

int get_malloced_size()
{
    return total_malloced;
}

#else

void *xmalloc(size_t size)
{
    return malloc(size);
}

void xfree(void *ptr)
{
    free(ptr);
    return;
}

#endif      /* if defined(DEBUG) */

