/* This file is part of Om.  Copyright (C) 2004 Dave Robillard.
 * 
 * Om is free software; you can redistribute it and/or modify it under the
 * terms of the GNU General Public License as published by the Free Software
 * Foundation; either version 2 of the License, or (at your option) any later
 * version.
 * 
 * Om is distributed in the hope that it will be useful, but WITHOUT ANY
 * WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU General Public License for details.
 * 
 * You should have received a copy of the GNU General Public License alongCont
 * with this program; if not, write to the Free Software Foundation, Inc.,
 * 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

#ifndef METADATAMODEL_H
#define METADATAMODEL_H

#include <string>
using std::string;

namespace LibOmClient {


/** Class to represent a piece of metadata.
 *
 * \ingroup libomclient
 */
class MetadataModel
{
public:
	MetadataModel(const string& path, const string& key, const string& value)
	: m_path(path),
	  m_key(key),
	  m_value(value)
	{}

	const string& path() const          { return m_path; }
	void          path(const string& p) { m_path = p; }
	const string& key() const           { return m_key; }
	const string& value() const         { return m_value; }

private:
	string m_path;
	string m_name;
	string m_parent_path;
	string m_key;
	string m_value;
};


} // namespace LibOmClient

#endif // METADATAMODEL_H

