/* This file is part of Om.  Copyright (C) 2004 Dave Robillard.
 * 
 * Om is free software; you can redistribute it and/or modify it under the
 * terms of the GNU General Public License as published by the Free Software
 * Foundation; either version 2 of the License, or (at your option) any later
 * version.
 * 
 * Om is distributed in the hope that it will be useful, but WITHOUT ANY
 * WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU General Public License for details.
 * 
 * You should have received a copy of the GNU General Public License along
 * with this program; if not, write to the Free Software Foundation, Inc.,
 * 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */


#ifndef PATCHLIBRARIAN_H
#define PATCHLIBRARIAN_H

#include <string>
#include <libxml/tree.h>
#include "DummyClientHooks.h"

using std::string;

namespace LibOmClient {

class PatchModel;
class NodeModel;
class ConnectionModel;
class PresetModel;
class Comm;
class ClientHooks;

	
/** Handles all patch saving and loading.
 *
 * \ingroup libomclient
 */
class PatchLibrarian
{
public:
	PatchLibrarian(Comm* comm, ClientHooks* client_hooks)
	: m_comm(comm), m_client_hooks(client_hooks)
	{}

	PatchLibrarian(Comm* comm)
	: m_comm(comm), m_client_hooks(new DummyClientHooks())
	{}

	void save_patch(const PatchModel* patch_model, const string& filename);
	string load_patch(PatchModel* pm);

private:
	Comm*            m_comm;
	ClientHooks*     m_client_hooks;
	PatchModel*      m_patch_model;
	NodeModel*       parse_node(const PatchModel* parent, xmlDocPtr doc, const xmlNodePtr cur);
	ConnectionModel* parse_connection(const PatchModel* parent, xmlDocPtr doc, const xmlNodePtr cur);
	PresetModel*     parse_preset(const PatchModel* parent, xmlDocPtr doc, const xmlNodePtr cur);
	void             load_subpatch(PatchModel* parent, xmlDocPtr doc, const xmlNodePtr cur);
	//ControlMapModel*     parse_control_map(xmlDocPtr doc, const xmlNodePtr cur, const string& patch_name);
};


} // namespace LibOmClient

#endif // PATCHLIBRARIAN_H
