/* This file is part of Om.  Copyright (C) 2004 Dave Robillard.
 * 
 * Om is free software; you can redistribute it and/or modify it under the
 * terms of the GNU General Public License as published by the Free Software
 * Foundation; either version 2 of the License, or (at your option) any later
 * version.
 * 
 * Om is distributed in the hope that it will be useful, but WITHOUT ANY
 * WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU General Public License for details.
 * 
 * You should have received a copy of the GNU General Public License along
 * with this program; if not, write to the Free Software Foundation, Inc.,
 * 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */


#include "AddSubpatchWindow.h"
#include "OmGtk.h"
#include "PatchController.h"
#include "NodeModel.h"
#include "Controller.h"

namespace OmGtk {


AddSubpatchWindow::AddSubpatchWindow(BaseObjectType* cobject, const Glib::RefPtr<Gnome::Glade::Xml>& xml)
: Gtk::Window(cobject)
{
	xml->get_widget("add_subpatch_name_entry", m_name_entry);
	xml->get_widget("add_subpatch_polyphony_spinbutton", m_polyphony_spinbutton);
	xml->get_widget("add_subpatch_ok_button", m_ok_button);
	xml->get_widget("add_subpatch_cancel_button", m_cancel_button);

	m_ok_button->signal_clicked().connect(sigc::mem_fun(this, &AddSubpatchWindow::ok_clicked));
	m_cancel_button->signal_clicked().connect(sigc::mem_fun(this, &AddSubpatchWindow::cancel_clicked));
}


/** Sets the patch controller for this window and initializes everything.
 *
 * This function MUST be called before using the window in any way!
 */
void
AddSubpatchWindow::patch_controller(PatchController* pc)
{
	m_patch_controller = pc;
}


///// Event Handlers //////


void
AddSubpatchWindow::ok_clicked()
{
	PatchModel* pm = new PatchModel(m_patch_controller->model()->path() +"/"+ m_name_entry->get_text(),
		m_polyphony_spinbutton->get_value_as_int());

	int x, y;
	m_patch_controller->get_new_module_location(x, y);
	pm->x(x);
	pm->y(y);
	char temp_buf[16];
	snprintf(temp_buf, 16, "%d", x);
	pm->set_metadata("module-x", temp_buf);
	snprintf(temp_buf, 16, "%d", y);
	pm->set_metadata("module-y", temp_buf);
	controller->create_patch(pm);
	hide();
}			


void
AddSubpatchWindow::cancel_clicked()
{
	hide();
}


} // namespace OmGtk
