/* This file is part of Om.  Copyright (C) 2004 Dave Robillard.
 * 
 * Om is free software; you can redistribute it and/or modify it under the
 * terms of the GNU General Public License as published by the Free Software
 * Foundation; either version 2 of the License, or (at your option) any later
 * version.
 * 
 * Om is distributed in the hope that it will be useful, but WITHOUT ANY
 * WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU General Public License for details.
 * 
 * You should have received a copy of the GNU General Public License along
 * with this program; if not, write to the Free Software Foundation, Inc.,
 * 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */


#include "OmGtkStateManager.h"
#include <cstdlib>
#include <cassert>
#include <iostream>
#include <fstream>
#include "OmGtk.h"
#include "PortModel.h"
#include "PluginInfo.h"

namespace OmGtk {
using namespace LibOmClient;
using Om::PluginInfo;


OmGtkStateManager::OmGtkStateManager()
: m_audio_port_color(0x3F5885FF),
  m_control_port_color(0x3F8558FF)
{
	/*m_window_location.x = 0;
	m_window_location.y = 0;
	m_window_size.x = 640;
	m_window_size.y = 480;
	m_zoom = 1.0;*/
}


OmGtkStateManager::~OmGtkStateManager() {
}

/*
void
OmGtkStateManager::load(string& filename) {	
	std::ifstream is;
	is.open(filename.c_str(), std::ios::in);

	if ( ! is.good()) return;

	m_module_locations.empty();

	string s;

	is >> s;
	if (s != "window_location") throw "Corrupt settings file.";
	is >> s;
	m_window_location.x = atoi(s.c_str());
	is >> s;
	m_window_location.y = atoi(s.c_str());

	is >> s;
	if (s != "window_size") throw "Corrupt settings file.";
	is >> s;
	m_window_size.x = atoi(s.c_str());
	is >> s;
	m_window_size.y = atoi(s.c_str());

	is >> s;
	if (s != "zoom_level") throw "Corrupt settings file.";
	is >> s;
	m_zoom = atof(s.c_str());

	ModuleLocation ml;
	while (1) {
		is >> s;
		if (is.eof()) break;
		
		ml.name = s;

		is >> s;
		if (s == "input") ml.type = Input;
		else if (s == "output") ml.type = Output;
		else if (s == "inputoutput") ml.type = InputOutput;
		else throw "Corrupt settings file.";

		is >> s;
		ml.loc.x = atoi(s.c_str());
		is >> s;
		ml.loc.y = atoi(s.c_str());

		m_module_locations.push_back(ml);
	}

	is.close();
}


void
OmGtkStateManager::save(string& filename) {
	app->window()->get_position(m_window_location.x, m_window_location.y);
	app->window()->get_size(m_window_size.x, m_window_size.y);

	std::ofstream os;
	os.open(filename.c_str(), std::ios::out);

	os << "window_location " << m_window_location.x << " " << m_window_location.y << std::endl;
	os << "window_size " << m_window_size.x << " " << m_window_size.y << std::endl;
	os << "zoom_level " << m_zoom << std::endl;

	ModuleLocation ml;
	for (std::list<ModuleLocation>::iterator i = m_module_locations.begin(); i != m_module_locations.end(); ++i) {
		ml = *i;
		os << ml.name;
		
		if (ml.type == Input) os << " input ";
		else if (ml.type == Output) os << " output ";
		else if (ml.type == InputOutput) os << " inputoutput ";
		else throw;

		os << ml.loc.x << " " << ml.loc.y << std::endl;
	}

	os.close();
}


iCoord
OmGtkStateManager::get_window_location() {
	return m_window_location;
}


void
OmGtkStateManager::set_window_location(iCoord loc) {
	m_window_location = loc;
}


iCoord
OmGtkStateManager::get_window_size() {
	return m_window_size;
}


void
OmGtkStateManager::set_window_size(iCoord size) {
	m_window_size = size;
}

*/


const int
OmGtkStateManager::get_port_color(const PortModel* pi) {
	assert(pi != NULL);
	
	if (pi->is_control()) {
		return m_control_port_color;
	} else if (pi->is_audio()) {
		return m_audio_port_color;
	}
	
	std::cerr << "Unknown port type!  Port will be bright red, this is an error." << std::endl;
	return 0xFF0000FF;
}


} // namespace OmGtk
