/* This file is part of Om.  Copyright (C) 2004 Dave Robillard.
 * 
 * Om is free software; you can redistribute it and/or modify it under the
 * terms of the GNU General Public License as published by the Free Software
 * Foundation; either version 2 of the License, or (at your option) any later
 * version.
 * 
 * Om is distributed in the hope that it will be useful, but WITHOUT ANY
 * WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU General Public License for details.
 * 
 * You should have received a copy of the GNU General Public License along
 * with this program; if not, write to the Free Software Foundation, Inc.,
 * 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

#ifndef ADDNODEEVENT_H
#define ADDNODEEVENT_H

#include "SlowEvent.h"
#include <string>

namespace Om {

	
class Patch;
class Node;
class TreeNode;
class PluginInfo;

using std::string;


/** An event to load a Node and insert it into a Patch.
 *
 * \ingroup engine
 */
class AddNodeEvent : public SlowEvent
{
public:
	AddNodeEvent(Request request, const string& path, PluginInfo* pi, bool poly);
	
	void prepare();
	void execute(uint sample_offset);
	void post_process();

private:
	string      m_patch_name;
	string      m_path;
	PluginInfo* m_plugin_info;
	bool        m_poly;
	Patch*      m_patch;
	Node*       m_node;
	TreeNode*   m_tree_node;
	bool        m_node_already_exists;
};


} // namespace Om

#endif // ADDNODEEVENT_H
