/* This file is part of Om.  Copyright (C) 2004 Dave Robillard.
 * 
 * Om is free software; you can redistribute it and/or modify it under the
 * terms of the GNU General Public License as published by the Free Software
 * Foundation; either version 2 of the License, or (at your option) any later
 * version.
 * 
 * Om is distributed in the hope that it will be useful, but WITHOUT ANY
 * WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU General Public License for details.
 * 
 * You should have received a copy of the GNU General Public License along
 * with this program; if not, write to the Free Software Foundation, Inc.,
 * 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */


#include "ControlInputNode.h"
#include "InputPort.h"
#include "OSCSender.h"
#include "OutputPort.h"
#include "PluginInfo.h"
#include "Patch.h"
#include "Connection.h"
#include "Om.h"
#include "JackDriver.h"
#include <cassert>

namespace Om {


ControlInputNode::ControlInputNode(const string& path, uint poly, Patch* parent, samplerate srate, size_t buffer_size)
: InputNode(path, poly, parent, srate, buffer_size)
{
	OutputPort* oport = new OutputPort(this, path + "/in", 0, m_poly, new PortInfo("in", CONTROL, OUTPUT), 1);
	m_external_port = new InputPort(parent, path.substr(0, path.find_last_of("/")) +"/"+ m_name,
		0, m_poly, new PortInfo(m_name, CONTROL, INPUT), 1);
	m_external_port->join(oport);

	m_num_ports = 1;
	m_ports.alloc(m_num_ports);
	m_ports.at(0) = oport;
	
	m_plugin_info.type(PluginInfo::Internal);
	m_plugin_info.lib_path("");
	m_plugin_info.lib_name("");
	m_plugin_info.plug_label("control_input");
	m_plugin_info.name("Om patch control input node");

	m_listnode = new ListNode<InputNode*>(this);
}


ControlInputNode::~ControlInputNode()
{
	deactivate();
	delete m_external_port;
}


void
ControlInputNode::activate()
{
	InternalNode::activate();
}


void
ControlInputNode::deactivate()
{
	InternalNode::deactivate();
}

	
void
ControlInputNode::add_to_patch(Patch* patch)
{
	patch->input_nodes().push_back(m_listnode);
	InternalNode::add_to_patch(patch);
}


void
ControlInputNode::remove_from_patch(Patch* patch)
{
	patch->input_nodes().remove(this);
}


void
ControlInputNode::send_creation_messages(lo_address addr) const
{
	om->osc_sender()->send_new_port_to(addr, m_external_port);
	InternalNode::send_creation_messages(addr);
}


void
ControlInputNode::send_deletion_messages(lo_address addr) const
{
	InternalNode::send_deletion_messages(addr);
	om->osc_sender()->send_port_removal_to(addr, m_external_port);
}

} // namespace Om

