/* This file is part of Om.  Copyright (C) 2004 Dave Robillard.
 * 
 * Om is free software; you can redistribute it and/or modify it under the
 * terms of the GNU General Public License as published by the Free Software
 * Foundation; either version 2 of the License, or (at your option) any later
 * version.
 * 
 * Om is distributed in the hope that it will be useful, but WITHOUT ANY
 * WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU General Public License for details.
 * 
 * You should have received a copy of the GNU General Public License along
 * with this program; if not, write to the Free Software Foundation, Inc.,
 * 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

#ifndef DSSIPLUGIN_H
#define DSSIPLUGIN_H

#include <dssi.h>
#include <lo/lo.h>
#include "LADSPAPlugin.h"
#include "Om.h"
#include "AlsaDriver.h"

namespace Om {


/** An instance of a DSSI plugin.
 */
class DSSIPlugin : public LADSPAPlugin
{
public:
	DSSIPlugin(const string& name, uint poly, Patch* parent, DSSI_Descriptor* descriptor, samplerate srate, size_t buffer_size);

	void activate();

	void set_ui_url(const string& url);
	void send_update();

	void set_control(int port_num, sample val);
	void configure(const string& key, const string& val);
	void program(int bank, int program);

	void run(size_t nframes);

	const PluginInfo& plugin_info() const { return m_plugin_info; }
	void plugin_info(const PluginInfo& pi)      { m_plugin_info = pi; }

private:
	string     m_ui_url;
	string     m_ui_base_path;
	lo_address m_ui_addr;

	DSSI_Descriptor* m_dssi_descriptor;

	PluginInfo m_plugin_info;
};


} // namespace Om

#endif // DSSIPLUGIN_H
