/* This file is part of Om.  Copyright (C) 2005 Dave Robillard.
 * 
 * Om is free software; you can redistribute it and/or modify it under the
 * terms of the GNU General Public License as published by the Free Software
 * Foundation; either version 2 of the License, or (at your option) any later
 * version.
 * 
 * Om is distributed in the hope that it will be useful, but WITHOUT ANY
 * WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU General Public License for details.
 * 
 * You should have received a copy of the GNU General Public License along
 * with this program; if not, write to the Free Software Foundation, Inc.,
 * 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

#ifndef DISCONNECTNODEEVENT_H
#define DISCONNECTNODEEVENT_H

#include <string>
#include "SlowEvent.h"
#include "List.h"

namespace Om {

	
class Patch;
class Node;
class Connection;
class InputPort;
class OutputPort;
class DisconnectionEvent;

using std::string;


/** An event to disconnect all connections to a Node.
 *
 * \ingroup engine
 */
class DisconnectNodeEvent : public SlowEvent
{
public:
	DisconnectNodeEvent(Request request, const string& node_path);
	DisconnectNodeEvent(Node* node);
	~DisconnectNodeEvent();

	void prepare();
	void execute(uint sample_offset);
	void post_process();

private:
	string                    m_node_path;
	Patch*                    m_patch;
	Node*                     m_node;
	List<DisconnectionEvent*> m_disconnection_events;
	
	bool m_succeeded;
	bool m_lookup;
	bool m_disconnect_parent;
};


} // namespace Om


#endif // DISCONNECTNODEEVENT_H
